/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.analysis.locals.LocalVariableLookup;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.fixes.BytecodeFixerUpper;
import org.sinytra.adapter.patch.fixes.MethodUpgrader;
import org.sinytra.adapter.patch.fixes.TypeAdapter;
import org.sinytra.adapter.patch.transformer.operation.CompoundMethodTransform;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformationUtil;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;
import org.sinytra.adapter.patch.util.OpcodeUtil;

public class WrapOperationSurgeon {
    public static Patch.Result tryUpgrade(MethodContext methodContext, MethodInsnNode cleanInsn, MethodInsnNode dirtyInsn) {
        MethodNode methodNode = methodContext.getMixinMethod();
        LocalVariableLookup mixinLocals = new LocalVariableLookup(methodNode);
        Multimap<Integer, VarInsnNode> usedVars = WrapOperationSurgeon.getUsedVars(mixinLocals, methodContext);
        HashMap<Integer, Pair<TypeAdapter, @Nullable Consumer<InsnList>>> adapters = new HashMap<Integer, Pair<TypeAdapter, Consumer<InsnList>>>();
        for (Integer key : usedVars.keys()) {
            Pair<TypeAdapter, Consumer<InsnList>> pair;
            if (key == 0 && (pair = WrapOperationSurgeon.findReplacementForInstance(cleanInsn, dirtyInsn, methodContext)) != null) {
                adapters.put(key, pair);
                continue;
            }
            return Patch.Result.PASS;
        }
        MethodQualifier oldQualifier = methodContext.getInjectionPointMethodQualifier();
        String newQualifier = MethodCallAnalyzer.getCallQualifier(dirtyInsn);
        return CompoundMethodTransform.builder(b -> b.modifyInjectionPoint("INVOKE", newQualifier, false, true)).onSuccess(() -> (c, m, mtx, ctx) -> {
            MethodUpgrader.upgradeWrapOperationLayered(methodContext, oldQualifier, MethodQualifier.create(newQualifier).orElseThrow());
            usedVars.forEach((i, insn) -> {
                @Nullable Pair adapter = (Pair)adapters.get(i);
                ((TypeAdapter)adapter.getFirst()).apply(methodNode.instructions, (AbstractInsnNode)insn);
            });
            for (Pair pair : adapters.values()) {
                if (pair.getSecond() == null) continue;
                ((Consumer)pair.getSecond()).accept(methodNode.instructions);
            }
            return Patch.Result.APPLY;
        }).apply(methodContext);
    }

    @Nullable
    private static @Nullable Pair<TypeAdapter, @Nullable Consumer<InsnList>> findReplacementForInstance(MethodInsnNode cleanInsn, MethodInsnNode dirtyInsn, MethodContext methodContext) {
        AbstractInsnNode abstractInsnNode;
        MethodNode cleanTargetMethod = methodContext.findCleanInjectionTarget().methodNode();
        List<AbstractInsnNode> receiverInsns = WrapOperationSurgeon.getMethodInvocationsInsns(cleanTargetMethod, cleanInsn, 0);
        if (!receiverInsns.isEmpty() && (abstractInsnNode = receiverInsns.getFirst()) instanceof VarInsnNode) {
            TypeInsnNode typeInsn;
            VarInsnNode varInsn = (VarInsnNode)abstractInsnNode;
            BytecodeFixerUpper bfu = methodContext.patchContext().environment().bytecodeFixerUpper();
            if (bfu == null) {
                return null;
            }
            LocalVariableLookup cleanLookup = methodContext.cleanLocalsTable();
            LocalVariableNode lvn = cleanLookup.getByIndex(varInsn.var);
            TypeAdapter typeAdapter = bfu.getTypeAdapter(Type.getObjectType((String)dirtyInsn.owner), Type.getType((String)lvn.desc));
            if (typeAdapter == null) {
                return null;
            }
            List<AbstractInsnNode> subList = receiverInsns.subList(1, receiverInsns.size());
            TypeAdapter adapter = typeAdapter.andThen((list, insn) -> list.insert(insn, AdapterUtil.insnList(AdapterUtil.cloneInsns(subList))));
            AbstractInsnNode abstractInsnNode2 = subList.getFirst();
            Consumer<InsnList> castCheck = abstractInsnNode2 instanceof TypeInsnNode && (typeInsn = (TypeInsnNode)abstractInsnNode2).getOpcode() == 192 ? list -> {
                ArrayList<AbstractInsnNode> originalWOCall = new ArrayList<AbstractInsnNode>(ParamTransformationUtil.findWrapOperationOriginalCallArgs(methodContext.getMixinMethod(), methodContext));
                originalWOCall.add(((AbstractInsnNode)originalWOCall.getLast()).getNext());
                originalWOCall.add(((AbstractInsnNode)originalWOCall.getLast()).getNext());
                originalWOCall.add(((AbstractInsnNode)originalWOCall.getLast()).getNext());
                List<AbstractInsnNode> cloned = AdapterUtil.cloneInsns(originalWOCall);
                boolean hasLabel = list.getFirst() instanceof LabelNode;
                LabelNode label = hasLabel ? (LabelNode)list.getFirst() : new LabelNode();
                InsnList check = AdapterUtil.insnList(new AbstractInsnNode[]{new LabelNode(), new VarInsnNode(25, 0), new TypeInsnNode(193, typeInsn.desc), new JumpInsnNode(154, label), new LabelNode()});
                typeAdapter.apply(check, check.get(1));
                check.add(AdapterUtil.insnList(cloned));
                check.add((AbstractInsnNode)new InsnNode(OpcodeUtil.getReturnOpcode(methodContext.getMixinMethod())));
                if (!hasLabel) {
                    check.add((AbstractInsnNode)label);
                }
                list.insert(check);
            } : null;
            return Pair.of((Object)adapter, castCheck);
        }
        return null;
    }

    @Nullable
    private static List<AbstractInsnNode> getMethodInvocationsInsns(MethodNode method, MethodInsnNode minsn, int param) {
        ArrayList<AbstractInsnNode> insns = new ArrayList<AbstractInsnNode>();
        if (WrapOperationSurgeon.getMethodInvocationsInsns(method, minsn, param, insns)) {
            return insns;
        }
        return null;
    }

    @Nullable
    private static boolean getMethodInvocationsInsns(MethodNode method, MethodInsnNode minsn, int param, List<AbstractInsnNode> insns) {
        ArrayList<AbstractInsnNode> methodInsns;
        MethodInsnNode invocation;
        List<AbstractInsnNode> invocationInsns = MethodCallAnalyzer.findMethodCallParamInsns(method, minsn);
        if (invocationInsns.isEmpty()) {
            return false;
        }
        AbstractInsnNode receiver = invocationInsns.getFirst();
        if (receiver instanceof VarInsnNode) {
            insns.addAll(0, invocationInsns);
            return true;
        }
        if (receiver instanceof TypeInsnNode) {
            TypeInsnNode typeInsn = (TypeInsnNode)receiver;
            AbstractInsnNode abstractInsnNode = receiver.getPrevious();
            if (abstractInsnNode instanceof VarInsnNode) {
                VarInsnNode varInsn = (VarInsnNode)abstractInsnNode;
                insns.addFirst((AbstractInsnNode)typeInsn);
                insns.addFirst((AbstractInsnNode)varInsn);
                return true;
            }
        }
        if (receiver instanceof MethodInsnNode && WrapOperationSurgeon.getMethodInvocationsInsns(method, invocation = (MethodInsnNode)receiver, param, methodInsns = new ArrayList<AbstractInsnNode>())) {
            insns.add(invocationInsns.get(param));
            insns.addAll(0, methodInsns);
            return true;
        }
        return false;
    }

    private static Multimap<Integer, VarInsnNode> getUsedVars(LocalVariableLookup mixinLocals, MethodContext methodContext) {
        MethodNode methodNode = methodContext.getMixinMethod();
        Type[] argsTypes = Type.getArgumentTypes((String)methodNode.desc);
        HashSet<Integer> paramVars = new HashSet<Integer>();
        for (int i = 0; i < argsTypes.length && !argsTypes[i].equals((Object)AdapterUtil.OPERATION_TYPE); ++i) {
            LocalVariableNode lvn = mixinLocals.getByParameterOrdinal(i);
            paramVars.add(lvn.index);
        }
        List<AbstractInsnNode> originalOpCall = ParamTransformationUtil.findWrapOperationOriginalCallArgs(methodNode, methodContext);
        HashMultimap usedVars = HashMultimap.create();
        for (AbstractInsnNode insn : methodNode.instructions) {
            if (!(insn instanceof VarInsnNode)) continue;
            VarInsnNode varInsn = (VarInsnNode)insn;
            if (originalOpCall.contains(insn) || !paramVars.contains(varInsn.var)) continue;
            usedVars.put((Object)varInsn.var, (Object)varInsn);
        }
        return usedVars;
    }
}

