/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.fixes;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.analysis.params.EnhancedParamsDiff;
import org.sinytra.adapter.patch.analysis.params.SimpleParamsDiffSnapshot;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.MethodQualifier;

@Deprecated
public class ModifyArgsOffsetTransformer {
    private static final MethodQualifier ARGS_GET = new MethodQualifier("Lorg/spongepowered/asm/mixin/injection/invoke/arg/Args;", "get", "(I)Ljava/lang/Object;");
    private static final MethodQualifier ARGS_SET = new MethodQualifier("Lorg/spongepowered/asm/mixin/injection/invoke/arg/Args;", "set", "(ILjava/lang/Object;)V");

    public static void handleModifiedDesc(MethodNode methodNode, String cleanDesc, String dirtyDesc) {
        Type[] dirtyArgs;
        Type[] cleanArgs = Type.getArgumentTypes((String)cleanDesc);
        SimpleParamsDiffSnapshot diff = EnhancedParamsDiff.create(cleanArgs, dirtyArgs = Type.getArgumentTypes((String)dirtyDesc));
        if (!diff.insertions().isEmpty()) {
            ModifyArgsOffsetTransformer.modify(methodNode, diff.insertions());
        }
    }

    public static void modify(MethodNode methodNode, List<Pair<Integer, Type>> insertions) {
        List<AbstractInsnNode> insns = MethodCallAnalyzer.analyzeMethod(methodNode, (insn, values) -> (ARGS_GET.matches((MethodInsnNode)insn) || ARGS_SET.matches((MethodInsnNode)insn)) && values.size() > 1, (insn, values) -> MethodCallAnalyzer.getSingleInsn(values, 1));
        for (AbstractInsnNode insn2 : insns) {
            if (insn2 instanceof IntInsnNode) {
                IntInsnNode iinsn = (IntInsnNode)insn2;
                insertions.forEach(pair -> {
                    int index = (Integer)pair.getFirst();
                    if (index >= iinsn.operand) {
                        ++iinsn.operand;
                    }
                });
                continue;
            }
            if (insn2 instanceof InsnNode) {
                InsnNode iinsn = (InsnNode)insn2;
                int index = AdapterUtil.getInsnIntConstValue((AbstractInsnNode)iinsn);
                int newIndex = index + (int)insertions.stream().filter(p -> (Integer)p.getFirst() >= index).count();
                methodNode.instructions.set(insn2, AdapterUtil.getIntConstInsn(newIndex));
                continue;
            }
            throw new UnsupportedOperationException("Whoopsie! We can't handle " + insn2.getClass().getName() + " instructions just yet!");
        }
    }
}

