/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.content.compiler;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.xeli.createmetalogistics.ModBlockEntities;
import com.xeli.createmetalogistics.MyConfig;
import com.xeli.createmetalogistics.component.ModDataComponents;
import com.xeli.createmetalogistics.component.TicketData;
import com.xeli.createmetalogistics.content.compiler.AttachModuleKt;
import com.xeli.createmetalogistics.content.compiler.CompilerExpansionModuleBlock;
import com.xeli.createmetalogistics.content.compiler.RemoveModuleKt;
import com.xeli.createmetalogistics.content.compiler.StockManifestCompilerBlockEntity;
import com.xeli.createmetalogistics.item.ModItems;
import com.xeli.createmetalogistics.screen.custom.ExpansionModuleMenu;
import com.xeli.createmetalogistics.util.EncoderContext;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u00012\u00020\u0002:\u000245B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0006\u0010\u001e\u001a\u00020\u0018J&\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0006J&\u0010#\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0006J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000f\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u000200J\b\u00101\u001a\u0004\u0018\u000102J\u0006\u00103\u001a\u00020(R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00066"}, d2={"Lcom/xeli/createmetalogistics/content/compiler/CompilerExpansionModuleBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "targetRelativePos", "Lnet/minecraft/core/Vec3i;", "getTargetRelativePos", "()Lnet/minecraft/core/Vec3i;", "setTargetRelativePos", "(Lnet/minecraft/core/Vec3i;)V", "inventory", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getInventory", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "behaviourOfParent", "Lcom/simibubi/create/content/logistics/packagerLink/LogisticallyLinkedBehaviour;", "getBehaviourOfParent", "()Lcom/simibubi/create/content/logistics/packagerLink/LogisticallyLinkedBehaviour;", "loadAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "drops", "onPlace", "level", "Lnet/minecraft/world/level/Level;", "oldState", "onRemove", "newState", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "i", "", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "acceptManifestTrigger", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "findCompilerBlockEntity", "Lcom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity;", "maxEntries", "Companion", "Inventory", "createmetalogistics-1.21.1"})
@SourceDebugExtension(value={"SMAP\nCompilerExpansionModuleBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerExpansionModuleBlockEntity.kt\ncom/xeli/createmetalogistics/content/compiler/CompilerExpansionModuleBlockEntity\n+ 2 EncoderContext.kt\ncom/xeli/createmetalogistics/util/EncoderContext\n*L\n1#1,211:1\n13#2,5:212\n*S KotlinDebug\n*F\n+ 1 CompilerExpansionModuleBlockEntity.kt\ncom/xeli/createmetalogistics/content/compiler/CompilerExpansionModuleBlockEntity\n*L\n50#1:212,5\n*E\n"})
public final class CompilerExpansionModuleBlockEntity
extends BlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vec3i targetRelativePos;
    @NotNull
    private final ItemStackHandler inventory;

    public CompilerExpansionModuleBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super((BlockEntityType)ModBlockEntities.INSTANCE.getCompilerExpansionModuleBlockEntityType().get(), pos, state);
        Vec3i vec3i = Vec3i.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"ZERO");
        this.targetRelativePos = vec3i;
        this.inventory = new Inventory();
    }

    @NotNull
    public final Vec3i getTargetRelativePos() {
        return this.targetRelativePos;
    }

    public final void setTargetRelativePos(@NotNull Vec3i vec3i) {
        Intrinsics.checkNotNullParameter((Object)vec3i, (String)"<set-?>");
        this.targetRelativePos = vec3i;
    }

    @NotNull
    public final ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nullable
    public final LogisticallyLinkedBehaviour getBehaviourOfParent() {
        StockManifestCompilerBlockEntity stockManifestCompilerBlockEntity = this.findCompilerBlockEntity();
        return stockManifestCompilerBlockEntity != null ? stockManifestCompilerBlockEntity.behaviour : null;
    }

    /*
     * WARNING - void declaration
     */
    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        void $this$runIfPresent$iv;
        void codec$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        RegistryOps registryOps = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)registryOps, (String)"createSerializationContext(...)");
        RegistryOps<Tag> $this$loadAdditional_u24lambda_u240 = EncoderContext.constructor-impl((RegistryOps<Tag>)registryOps);
        boolean bl = false;
        Tag tag2 = tag.get("TargetPos");
        Codec codec = Vec3i.CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"CODEC");
        Codec codec2 = codec;
        KMutableProperty0 kMutableProperty0 = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return ((CompilerExpansionModuleBlockEntity)((Object)this.receiver)).getTargetRelativePos();
            }

            public void set(Object value) {
                ((CompilerExpansionModuleBlockEntity)((Object)this.receiver)).setTargetRelativePos((Vec3i)value);
            }
        };
        boolean bl2 = false;
        Optional result$iv = codec$iv.decode((DynamicOps)$this$loadAdditional_u24lambda_u240, (Object)$this$runIfPresent$iv).result();
        if (result$iv.isPresent()) {
            Vec3i p0 = (Vec3i)((com.mojang.datafixers.util.Pair)result$iv.get()).getFirst();
            boolean bl3 = false;
            kMutableProperty0.set((Object)p0);
        }
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        RegistryOps registryOps = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)registryOps, (String)"createSerializationContext(...)");
        RegistryOps<Tag> $this$saveAdditional_u24lambda_u241 = EncoderContext.constructor-impl((RegistryOps<Tag>)registryOps);
        boolean bl = false;
        Codec codec = Vec3i.CODEC;
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"CODEC");
        EncoderContext.store-impl($this$saveAdditional_u24lambda_u241, tag, "TargetPos", codec, this.targetRelativePos);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    public final void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        int n = this.inventory.getSlots();
        for (int i = 0; i < n; ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        Containers.dropContents((Level)level, (BlockPos)this.worldPosition, (Container)((Container)inv));
    }

    public final void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
            if (level.isClientSide) break block1;
            StockManifestCompilerBlockEntity stockManifestCompilerBlockEntity = this.findCompilerBlockEntity();
            if (stockManifestCompilerBlockEntity != null) {
                AttachModuleKt.attachModule(stockManifestCompilerBlockEntity, this);
            }
        }
    }

    public final void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
            if (level.isClientSide) break block1;
            StockManifestCompilerBlockEntity stockManifestCompilerBlockEntity = this.findCompilerBlockEntity();
            if (stockManifestCompilerBlockEntity != null) {
                RemoveModuleKt.removeModule(stockManifestCompilerBlockEntity, this);
            }
        }
    }

    @NotNull
    public AbstractContainerMenu createMenu(int i, @NotNull net.minecraft.world.entity.player.Inventory inventory, @NotNull Player player) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        StockManifestCompilerBlockEntity target = this.findCompilerBlockEntity();
        return new ExpansionModuleMenu(i, inventory, this, target != null, (object = target) != null && (object = ((StockManifestCompilerBlockEntity)((Object)object)).validExpansionModules()) != null ? object.indexOf((Object)this) : -1);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = Component.translatable((String)"container.createmetalogistics.expansion_module");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    public final void acceptManifestTrigger(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        this.inventory.setStackInSlot(0, itemStack);
        this.setChanged();
    }

    @Nullable
    public final StockManifestCompilerBlockEntity findCompilerBlockEntity() {
        BlockPos targetPos = this.getBlockPos().offset(this.targetRelativePos);
        Level level = this.level;
        BlockEntity blockEntity = level != null ? level.getBlockEntity(targetPos) : null;
        return blockEntity instanceof StockManifestCompilerBlockEntity ? (StockManifestCompilerBlockEntity)blockEntity : null;
    }

    public final int maxEntries() {
        return MyConfig.INSTANCE.getManifestMaxBytes();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J<\u0010\f\u001a \u0012\u0004\u0012\u00020\u000e\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\r0\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/xeli/createmetalogistics/content/compiler/CompilerExpansionModuleBlockEntity$Companion;", "", "<init>", "()V", "registerCapabilities", "", "event", "Lnet/neoforged/neoforge/capabilities/RegisterCapabilitiesEvent;", "maxDistance", "", "getMaxDistance", "()I", "isOffsetValid", "Lkotlin/Pair;", "", "Ljava/util/Optional;", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "offset", "Lnet/minecraft/core/Vec3i;", "cooldownModifier", "", "getCooldownModifier", "()D", "createmetalogistics-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerCapabilities(@NotNull RegisterCapabilitiesEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.INSTANCE.getCompilerExpansionModuleBlockEntityType().get(), (arg_0, arg_1) -> Companion.registerCapabilities$lambda$1(Companion::registerCapabilities$lambda$0, arg_0, arg_1));
        }

        public final int getMaxDistance() {
            return MyConfig.INSTANCE.getExpansionModuleMaxDistance();
        }

        @NotNull
        public final Pair<Boolean, Optional<Pair<Integer, Integer>>> isOffsetValid(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull Vec3i offset) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
            int thisDistance = Math.max(Math.abs(offset.getX()), Math.max(Math.abs(offset.getY()), Math.abs(offset.getZ())));
            if (thisDistance > this.getMaxDistance()) {
                return new Pair((Object)false, Optional.of(TuplesKt.to((Object)this.getMaxDistance(), (Object)thisDistance)));
            }
            return new Pair((Object)true, Optional.empty());
        }

        public final double getCooldownModifier() {
            return MyConfig.INSTANCE.getExpansionModuleCooldownModifier();
        }

        private static final IItemHandler registerCapabilities$lambda$0(CompilerExpansionModuleBlockEntity be, Direction d) {
            return (IItemHandler)be.getInventory();
        }

        private static final IItemHandler registerCapabilities$lambda$1(Function2 $tmp0, Object p0, Direction p1) {
            return (IItemHandler)$tmp0.invoke(p0, (Object)p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/xeli/createmetalogistics/content/compiler/CompilerExpansionModuleBlockEntity$Inventory;", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "<init>", "(Lcom/xeli/createmetalogistics/content/compiler/CompilerExpansionModuleBlockEntity;)V", "extractItem", "Lnet/minecraft/world/item/ItemStack;", "slot", "", "amount", "simulate", "", "isItemValid", "stack", "insertItem", "setStackInSlot", "", "onContentsChanged", "createmetalogistics-1.21.1"})
    private final class Inventory
    extends ItemStackHandler {
        public Inventory() {
            super(2);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack itemStack;
            if (slot != 0) {
                ItemStack itemStack2 = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
                return itemStack2;
            }
            ItemStack it = itemStack = super.extractItem(slot, amount, simulate);
            boolean bl = false;
            if (!simulate) {
                this.onContentsChanged(0);
            }
            ItemStack itemStack3 = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"also(...)");
            return itemStack3;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (slot == 0) {
                return stack.is((Holder)ModItems.INSTANCE.getManifestItem());
            }
            return stack.is((Holder)ModItems.INSTANCE.getTicketItem());
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (stack.isEmpty()) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            if (slot != 1) {
                return stack;
            }
            StockManifestCompilerBlockEntity target = CompilerExpansionModuleBlockEntity.this.findCompilerBlockEntity();
            if (!simulate && target != null) {
                if (stack.is((Holder)ModItems.INSTANCE.getTicketItem())) {
                    Object object = stack.get((Supplier)ModDataComponents.INSTANCE.getTICKET());
                    Intrinsics.checkNotNull((Object)object);
                    target.makeRequest((TicketData)object);
                }
                this.onContentsChanged(slot);
            }
            ItemStack itemStack = stack.copyWithCount(stack.getCount() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
            return itemStack;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            switch (slot) {
                case 1: {
                    StockManifestCompilerBlockEntity target = CompilerExpansionModuleBlockEntity.this.findCompilerBlockEntity();
                    if (!stack.is((Holder)ModItems.INSTANCE.getTicketItem()) || target == null) break;
                    Object object = stack.get((Supplier)ModDataComponents.INSTANCE.getTICKET());
                    Intrinsics.checkNotNull((Object)object);
                    target.makeRequest((TicketData)object);
                    break;
                }
                case 0: {
                    super.setStackInSlot(slot, stack);
                }
            }
        }

        protected void onContentsChanged(int slot) {
            CompilerExpansionModuleBlockEntity.this.setChanged();
            Level level = CompilerExpansionModuleBlockEntity.this.level;
            Intrinsics.checkNotNull((Object)level);
            if (!level.isClientSide()) {
                Level level2 = CompilerExpansionModuleBlockEntity.this.level;
                Intrinsics.checkNotNull((Object)level2);
                BlockState blockState = level2.getBlockState(CompilerExpansionModuleBlockEntity.this.getBlockPos());
                Block block = blockState.getBlock();
                if (block instanceof CompilerExpansionModuleBlock) {
                    Level level3 = CompilerExpansionModuleBlockEntity.this.level;
                    Intrinsics.checkNotNull((Object)level3);
                    BlockPos blockPos = CompilerExpansionModuleBlockEntity.this.getBlockPos();
                    CompilerExpansionModuleBlock compilerExpansionModuleBlock = (CompilerExpansionModuleBlock)block;
                    Intrinsics.checkNotNull((Object)blockState);
                    Level level4 = CompilerExpansionModuleBlockEntity.this.level;
                    Intrinsics.checkNotNull((Object)level4);
                    BlockEntity blockEntity = CompilerExpansionModuleBlockEntity.this;
                    BlockPos blockPos2 = CompilerExpansionModuleBlockEntity.this.getBlockPos();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
                    level3.setBlockAndUpdate(blockPos, compilerExpansionModuleBlock.updateStateBasedOnDetectedStates(blockState, level4, blockEntity, blockPos2));
                }
            }
        }
    }
}

