/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.rei.display;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class ScrollableTextWidget
extends WidgetWithBounds {
    private final Rectangle bounds;
    private final List<FormattedCharSequence> texts;
    private final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            Rectangle bounds = ScrollableTextWidget.this.getBounds();
            return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
        }

        public int getMaxScrollHeight() {
            int i = 2;
            for (FormattedCharSequence entry : ScrollableTextWidget.this.texts) {
                int n;
                if (entry == null) {
                    n = 4;
                } else {
                    Objects.requireNonNull(ScrollableTextWidget.this.font);
                    n = 9;
                }
                i += n;
            }
            return i;
        }
    };

    public ScrollableTextWidget(Rectangle bounds, List<FormattedText> texts) {
        this.bounds = Objects.requireNonNull(bounds);
        this.texts = Lists.newArrayList();
        for (FormattedText text : texts) {
            if (!this.texts.isEmpty()) {
                this.texts.add(null);
            }
            this.texts.addAll(Minecraft.getInstance().font.split(text, bounds.width - 11));
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.containsMouse(mouseX, mouseY)) {
            this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -scrollY, true);
            return true;
        }
        return false;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return null;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean isDragging() {
        return false;
    }

    public void setDragging(boolean isDragging) {
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.scrolling.updatePosition(delta);
        Rectangle innerBounds = this.scrolling.getScissorBounds();
        try (CloseableScissors scissors = ScrollableTextWidget.scissor((GuiGraphics)graphics, (Rectangle)innerBounds);){
            int currentY = -this.scrolling.scrollAmountInt() + innerBounds.y;
            for (FormattedCharSequence text : this.texts) {
                int n;
                if (text != null) {
                    Objects.requireNonNull(this.font);
                    if (currentY + 9 >= innerBounds.y && currentY <= innerBounds.getMaxY()) {
                        graphics.drawString(this.font, text, innerBounds.x + 2, currentY + 2, REIRuntime.getInstance().isDarkThemeEnabled() ? -4473925 : -16185079, false);
                    }
                }
                if (text == null) {
                    n = 4;
                } else {
                    Objects.requireNonNull(this.font);
                    n = 9;
                }
                currentY += n;
            }
        }
        if (this.scrolling.hasScrollBar()) {
            if (this.scrolling.scrollAmount() > 8.0) {
                graphics.fillGradient(innerBounds.x, innerBounds.y, innerBounds.getMaxX(), innerBounds.y + 16, -3750202, 0xC6C6C6);
            }
            if ((double)this.scrolling.getMaxScroll() - this.scrolling.scrollAmount() > 8.0) {
                graphics.fillGradient(innerBounds.x, innerBounds.getMaxY() - 16, innerBounds.getMaxX(), innerBounds.getMaxY(), 0xC6C6C6, -3750202);
            }
        }
        scissors = ScrollableTextWidget.scissor((GuiGraphics)graphics, (Rectangle)this.scrolling.getBounds());
        try {
            this.scrolling.renderScrollBar(graphics, 0, 1.0f, 1.0f);
        }
        finally {
            if (scissors != null) {
                scissors.close();
            }
        }
    }

    public List<? extends GuiEventListener> children() {
        return Collections.emptyList();
    }
}

