/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.ExtendedWrenchesData;
import net.vercte.extendedwrenches.wrench.ExtendedWrenchItemRenderer;
import net.vercte.extendedwrenches.wrench.WrenchMaterial;
import net.vercte.extendedwrenches.wrench.WrenchPart;
import net.vercte.extendedwrenches.wrench.components.WrenchMaterialComponent;

public class ExtendedWrenchItem
extends WrenchItem {
    public static final int DEFAULT_GRIP_COLOR = -3715257;

    public ExtendedWrenchItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack swapMaterial(ItemStack stack, WrenchPart part, Holder<WrenchMaterial> holder) {
        WrenchMaterialComponent materials = (WrenchMaterialComponent)stack.getOrDefault(ExtendedWrenchesData.WRENCH_MATERIAL_COMPONENT, (Object)WrenchMaterialComponent.empty());
        stack.set(ExtendedWrenchesData.WRENCH_MATERIAL_COMPONENT, (Object)materials.withChangedMaterial(part, holder));
        return stack;
    }

    public static boolean hasMaterial(ItemStack stack, WrenchPart part, @Nullable ResourceLocation material) {
        if (material == null) {
            return false;
        }
        WrenchMaterialComponent materials = (WrenchMaterialComponent)stack.getOrDefault(ExtendedWrenchesData.WRENCH_MATERIAL_COMPONENT, (Object)WrenchMaterialComponent.empty());
        Holder<WrenchMaterial> holderMaterial = materials.getMaterialHolder(part);
        if (holderMaterial != null && holderMaterial.is(material)) {
            return true;
        }
        if (!materials.partPresent(part)) {
            String locString = material.toString();
            if (part == WrenchPart.HEAD && locString.equals("extendedwrenches:gold_head")) {
                return true;
            }
            if (part == WrenchPart.HANDLE && locString.equals("extendedwrenches:dark_oak_handle")) {
                return true;
            }
            return part == WrenchPart.COG && locString.equals("extendedwrenches:spruce");
        }
        return false;
    }

    @Nullable
    public static ResourceLocation getMaterialTexture(ItemStack stack, WrenchPart part) {
        WrenchMaterialComponent materials = (WrenchMaterialComponent)stack.getOrDefault(ExtendedWrenchesData.WRENCH_MATERIAL_COMPONENT, (Object)WrenchMaterialComponent.empty());
        Holder<WrenchMaterial> holderMaterial = materials.getMaterialHolder(part);
        if (holderMaterial == null) {
            return null;
        }
        return ((WrenchMaterial)holderMaterial.value()).texture();
    }

    public static ItemStack convertWrench(ItemStack original) {
        if (original.is((Item)AllItems.WRENCH.get())) {
            return ExtendedItems.WRENCH.asStack();
        }
        return original.copy();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new ExtendedWrenchItemRenderer()));
    }

    @Nonnull
    public String getDescriptionId() {
        return "item.create.wrench";
    }
}

