/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.datagen;

import com.simibubi.create.AllItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.ExtendedWrenches;
import net.vercte.extendedwrenches.wrench.WrenchMaterialSwapRecipe;
import net.vercte.extendedwrenches.wrench.WrenchPart;
import org.jetbrains.annotations.NotNull;

public class ExtendedWrenchSwapRecipeProvider
extends RecipeProvider {
    private RecipeOutput consumer;
    private String folder = "wrench";

    public ExtendedWrenchSwapRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput consumer) {
        this.consumer = consumer;
        this.setFolder("wrench/head");
        this.head("amethyst_head", (TagKey<Item>)Tags.Items.GEMS_AMETHYST);
        this.head("andesite_alloy_head", new ItemLike[]{AllItems.ANDESITE_ALLOY});
        this.head("brass_head", this.common("ingots/brass"));
        this.head("copper_head", (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        this.head("diamond_head", (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
        this.head("emerald_head", (TagKey<Item>)Tags.Items.GEMS_EMERALD);
        this.head("gold_head", (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.head("iron_head", (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.head("polished_rose_quartz_head", new ItemLike[]{AllItems.POLISHED_ROSE_QUARTZ});
        this.head("zinc_head", this.common("ingots/zinc"));
        this.head("quartz", new ItemLike[]{Items.QUARTZ});
        this.head("lapis_lazuli", new ItemLike[]{Items.LAPIS_LAZULI});
        this.setFolder("wrench/handle");
        this.handle("acacia_handle", new ItemLike[]{Items.ACACIA_PLANKS});
        this.handle("bamboo_handle", new ItemLike[]{Items.BAMBOO_PLANKS});
        this.handle("birch_handle", new ItemLike[]{Items.BIRCH_PLANKS});
        this.handle("cherry_handle", new ItemLike[]{Items.CHERRY_PLANKS});
        this.handle("crimson_handle", new ItemLike[]{Items.CRIMSON_PLANKS});
        this.handle("dark_oak_handle", new ItemLike[]{Items.DARK_OAK_PLANKS});
        this.handle("jungle_handle", new ItemLike[]{Items.JUNGLE_PLANKS});
        this.handle("mangrove_handle", new ItemLike[]{Items.MANGROVE_PLANKS});
        this.handle("oak_handle", new ItemLike[]{Items.OAK_PLANKS});
        this.handle("spruce_handle", new ItemLike[]{Items.SPRUCE_PLANKS});
        this.handle("warped_handle", new ItemLike[]{Items.WARPED_PLANKS});
        this.setFolder("wrench/cog");
        this.cog("acacia_cog", new ItemLike[]{Items.ACACIA_PLANKS});
        this.cog("bamboo_cog", new ItemLike[]{Items.BAMBOO_PLANKS});
        this.cog("birch_cog", new ItemLike[]{Items.BIRCH_PLANKS});
        this.cog("cherry_cog", new ItemLike[]{Items.CHERRY_PLANKS});
        this.cog("crimson_cog", new ItemLike[]{Items.CRIMSON_PLANKS});
        this.cog("dark_oak_cog", new ItemLike[]{Items.DARK_OAK_PLANKS});
        this.cog("jungle_cog", new ItemLike[]{Items.JUNGLE_PLANKS});
        this.cog("mangrove_cog", new ItemLike[]{Items.MANGROVE_PLANKS});
        this.cog("oak_cog", new ItemLike[]{Items.OAK_PLANKS});
        this.cog("spruce_cog", new ItemLike[]{Items.SPRUCE_PLANKS});
        this.cog("warped_cog", new ItemLike[]{Items.WARPED_PLANKS});
    }

    private void setFolder(String folder) {
        this.folder = folder;
    }

    private TagKey<Item> common(String tag) {
        return TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)tag));
    }

    private void head(String material, ItemLike ... addition) {
        this.head(material, Ingredient.of((ItemLike[])addition));
    }

    private void head(String material, TagKey<Item> addition) {
        this.head(material, Ingredient.of(addition));
    }

    private void head(String material, Ingredient addition) {
        this.recipe(material, (ItemLike)ExtendedItems.WRENCH_HEAD_AUGMENT, addition, WrenchPart.HEAD);
    }

    private void handle(String material, ItemLike ... addition) {
        this.handle(material, Ingredient.of((ItemLike[])addition));
    }

    private void handle(String material, Ingredient addition) {
        this.recipe(material, (ItemLike)ExtendedItems.WRENCH_HANDLE_AUGMENT, addition, WrenchPart.HANDLE);
    }

    private void cog(String material, ItemLike ... addition) {
        this.cog(material, Ingredient.of((ItemLike[])addition));
    }

    private void cog(String material, Ingredient addition) {
        this.recipe(material, (ItemLike)ExtendedItems.WRENCH_COG_AUGMENT, addition, WrenchPart.COG);
    }

    private void recipe(String material, ItemLike template, Ingredient addition, WrenchPart part) {
        ResourceLocation recipeLocation = ExtendedWrenches.asResource(this.folder + "/" + material + "_swap");
        new WrenchMaterialSwapRecipe.Builder(recipeLocation).material(material).template(template).addition(addition).part(part).save(this.consumer);
    }
}

