/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.vercte.extendedwrenches.ExtendedWrenches;
import net.vercte.extendedwrenches.datagen.ExtendedEntriesProvider;
import net.vercte.extendedwrenches.datagen.ExtendedWrenchSwapRecipeProvider;
import net.vercte.extendedwrenches.wrench.WrenchMaterial;
import net.vercte.extendedwrenches.wrench.components.WrenchMaterialComponent;

public class ExtendedWrenchesData {
    public static final DeferredRegister.DataComponents COMPONENT_REGISTRAR = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"extendedwrenches");
    public static final ResourceKey<Registry<WrenchMaterial>> WRENCH_MATERIAL = ExtendedWrenchesData.key("wrench_material");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<WrenchMaterialComponent>> WRENCH_MATERIAL_COMPONENT = COMPONENT_REGISTRAR.registerComponentType("wrench_material", builder -> builder.persistent(WrenchMaterialComponent.CODEC).networkSynchronized(WrenchMaterialComponent.STREAM_CODEC));

    private static <T> ResourceKey<Registry<T>> key(String name) {
        return ResourceKey.createRegistryKey((ResourceLocation)ExtendedWrenches.asResource(name));
    }

    public static void register(IEventBus bus) {
        COMPONENT_REGISTRAR.register(bus);
    }

    public static void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(WRENCH_MATERIAL, WrenchMaterial.CODEC, WrenchMaterial.CODEC);
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new ExtendedEntriesProvider(output, lookupProvider));
            generator.addProvider(true, (DataProvider)new ExtendedWrenchSwapRecipeProvider(output, lookupProvider));
        }
    }
}

