/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.util.network;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.attachment.FrontAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.rear.BannerPostRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.ExtendableRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.RearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.platform.Platform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public final class ClientPackets
extends Enum<ClientPackets> {
    public static final Map<ResourceLocation, BiConsumer<Minecraft, FriendlyByteBuf>> CLIENTBOUND_HANDLERS;
    private static final /* synthetic */ ClientPackets[] $VALUES;

    public static ClientPackets[] values() {
        return (ClientPackets[])$VALUES.clone();
    }

    public static ClientPackets valueOf(String name) {
        return Enum.valueOf(ClientPackets.class, name);
    }

    public static void registerReceiver(ResourceLocation rl, BiConsumer<Minecraft, FriendlyByteBuf> run) {
        CLIENTBOUND_HANDLERS.put(rl, run);
    }

    public static void sendServerboundAutomobileSyncPacket(AutomobileEntity entity) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(entity.getId());
        entity.writeSyncStateData(buf);
        Platform.get().clientSendPacket(Automobility.rl("sync_automobile_data"), buf);
    }

    public static void requestSyncAutomobileComponentsPacket(AutomobileEntity entity) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(entity.getId());
        Platform.get().clientSendPacket(Automobility.rl("request_sync_automobile_components"), buf);
    }

    public static void initClient() {
        ClientPackets.registerReceiver(Automobility.rl("sync_automobile_data"), (client, buf) -> {
            FriendlyByteBuf dup = new FriendlyByteBuf(buf.copy());
            int entityId = dup.readInt();
            client.execute(() -> {
                Entity patt0$temp = client.player.level().getEntity(entityId);
                if (patt0$temp instanceof AutomobileEntity) {
                    AutomobileEntity automobile = (AutomobileEntity)patt0$temp;
                    automobile.readSyncStateData(dup);
                }
            });
        });
        ClientPackets.registerReceiver(Automobility.rl("sync_automobile_attachments"), (client, buf) -> {
            int entityId = buf.readInt();
            RearAttachmentType<?> rearAtt = RearAttachmentType.REGISTRY.getOrDefault(ResourceLocation.tryParse((String)buf.readUtf()));
            FrontAttachmentType<?> frontAtt = FrontAttachmentType.REGISTRY.getOrDefault(ResourceLocation.tryParse((String)buf.readUtf()));
            client.execute(() -> {
                Entity patt0$temp = client.player.level().getEntity(entityId);
                if (patt0$temp instanceof AutomobileEntity) {
                    AutomobileEntity automobile = (AutomobileEntity)patt0$temp;
                    automobile.setRearAttachment(rearAtt);
                    automobile.setFrontAttachment(frontAtt);
                }
            });
        });
        ClientPackets.registerReceiver(Automobility.rl("update_banner_post"), (client, buf) -> {
            BannerPatternLayers layers;
            DyeColor baseColor;
            RegistryFriendlyByteBuf rbuf = new RegistryFriendlyByteBuf((ByteBuf)buf, client.level.registryAccess());
            int entityId = buf.readInt();
            if (buf.readBoolean()) {
                baseColor = (DyeColor)DyeColor.STREAM_CODEC.decode(buf);
                layers = (BannerPatternLayers)BannerPatternLayers.STREAM_CODEC.decode((Object)rbuf);
            } else {
                baseColor = null;
                layers = null;
            }
            client.execute(() -> {
                AutomobileEntity automobile;
                RearAttachment patt1$temp;
                Entity patt0$temp = client.player.level().getEntity(entityId);
                if (patt0$temp instanceof AutomobileEntity && (patt1$temp = (automobile = (AutomobileEntity)patt0$temp).getRearAttachment()) instanceof BannerPostRearAttachment) {
                    BannerPostRearAttachment bannerPost = (BannerPostRearAttachment)patt1$temp;
                    bannerPost.setBanner(baseColor, layers);
                }
            });
        });
        ClientPackets.registerReceiver(Automobility.rl("update_extendable_attachment"), (client, buf) -> {
            int entityId = buf.readInt();
            boolean extended = buf.readBoolean();
            client.execute(() -> {
                AutomobileEntity automobile;
                RearAttachment patt1$temp;
                Entity patt0$temp = client.player.level().getEntity(entityId);
                if (patt0$temp instanceof AutomobileEntity && (patt1$temp = (automobile = (AutomobileEntity)patt0$temp).getRearAttachment()) instanceof ExtendableRearAttachment) {
                    ExtendableRearAttachment att = (ExtendableRearAttachment)patt1$temp;
                    att.setExtended(extended);
                }
            });
        });
    }

    private static /* synthetic */ ClientPackets[] $values() {
        return new ClientPackets[0];
    }

    static {
        $VALUES = ClientPackets.$values();
        CLIENTBOUND_HANDLERS = new HashMap<ResourceLocation, BiConsumer<Minecraft, FriendlyByteBuf>>();
    }
}

