/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.util.duck;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface CollisionArea {
    public boolean isPointInside(double var1, double var3, double var5);

    public boolean boxIntersects(AABB var1);

    public double highestY(double var1, double var3, double var5);

    public static CollisionArea box(double ax, double ay, double az, double bx, double by, double bz) {
        return (CollisionArea)new AABB(ax, ay, az, bx, by, bz);
    }

    public static CollisionArea entity(Entity entity) {
        if (entity instanceof CollisionArea) {
            CollisionArea col = (CollisionArea)entity;
            return col;
        }
        return (CollisionArea)entity.getBoundingBox();
    }

    public record SlopeArea(AABB box, double xSlope, double zSlope, double originY) implements CollisionArea
    {
        @Override
        public boolean isPointInside(double x, double y, double z) {
            return ((CollisionArea)this.box()).isPointInside(x, y, z);
        }

        @Override
        public boolean boxIntersects(AABB box) {
            return ((CollisionArea)this.box()).boxIntersects(box);
        }

        @Override
        public double highestY(double x, double y, double z) {
            Vec3 planeOrigin = this.box().getBottomCenter().add(0.0, this.box().getYsize() - 1.0 + this.originY(), 0.0);
            Vec3 originToPoint = new Vec3(x - planeOrigin.x(), y - planeOrigin.y(), z - planeOrigin.z());
            return planeOrigin.y() + originToPoint.x() * this.xSlope() + originToPoint.z() * this.zSlope();
        }
    }
}

