/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class DefaultRegistrar<V> {
    public final ResourceKey<Registry<V>> registryKey;
    private final Map<ResourceKey<V>, V> toRegister = new HashMap<ResourceKey<V>, V>();

    public DefaultRegistrar(ResourceKey<Registry<V>> registry) {
        this.registryKey = registry;
    }

    public ResourceKey<V> register(ResourceLocation id, V value) {
        ResourceKey key = ResourceKey.create(this.registryKey, (ResourceLocation)id);
        this.toRegister.put(key, value);
        return key;
    }

    public ResourceKey<V> register(Candidate<V> c) {
        return this.register(c.id(), c.value());
    }

    public void bootstrap(RegistrationContext<V> registry) {
        for (Map.Entry<ResourceKey<V>, V> e : this.toRegister.entrySet()) {
            registry.register(e.getKey(), e.getValue());
        }
    }

    public static <V> Candidate<V> cand(ResourceLocation id, V value) {
        return new Candidate<V>(id, value);
    }

    public record Candidate<V>(ResourceLocation id, V value) {
    }

    public static interface RegistrationContext<V> {
        public void register(ResourceKey<V> var1, V var2);
    }
}

