/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.item.AutomobileComponentItem;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipe;
import java.util.ArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class AutoMechanicTableRecipeSerializer
implements RecipeSerializer<AutoMechanicTableRecipe> {
    public static final AutoMechanicTableRecipeSerializer INSTANCE = new AutoMechanicTableRecipeSerializer();
    public static final Codec<ItemStack> AUTO_COMPONENT_STACK = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("item").forGetter(ItemStack::getItemHolder), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(ItemStack::getCount), (App)ResourceLocation.CODEC.fieldOf("component").forGetter(s -> {
        Item item = s.getItem();
        if (item instanceof AutomobileComponentItem.Dynamic) {
            AutomobileComponentItem.Dynamic cItem = (AutomobileComponentItem.Dynamic)item;
            return cItem.getComponentId((ItemStack)s, null);
        }
        if (item instanceof AutomobileComponentItem.Builtin) {
            AutomobileComponentItem.Builtin cItem = (AutomobileComponentItem.Builtin)item;
            return cItem.getComponent((ItemStack)s, null).getId();
        }
        return Automobility.rl("empty");
    })).apply((Applicative)inst, (i, c, p) -> {
        ItemStack stack = ((Item)i.value()).getDefaultInstance();
        stack.setCount(c.intValue());
        Item item = stack.getItem();
        if (item instanceof AutomobileComponentItem.Dynamic) {
            AutomobileComponentItem.Dynamic cItem = (AutomobileComponentItem.Dynamic)item;
            cItem.setComponent(stack, ResourceKey.create(cItem.registryKey, (ResourceLocation)p));
        } else {
            stack.set(AutomobilityItems.COMPONENT_GENERIC_AUTO_PART.require(), p);
        }
        return stack;
    }));
    public static final MapCodec<AutoMechanicTableRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("category").forGetter(AutoMechanicTableRecipe::getCategory), (App)Codec.list((Codec)Ingredient.CODEC).fieldOf("ingredients").forGetter(r -> r.ingredients), (App)AUTO_COMPONENT_STACK.fieldOf("result").forGetter(AutoMechanicTableRecipe::getResultItem), (App)Codec.INT.fieldOf("sortnum").forGetter(r -> r.sortNum)).apply((Applicative)inst, AutoMechanicTableRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AutoMechanicTableRecipe> STREAM_CODEC = StreamCodec.of(AutoMechanicTableRecipeSerializer::toNetwork, AutoMechanicTableRecipeSerializer::fromNetwork);

    public static AutoMechanicTableRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
        ResourceLocation category = ResourceLocation.tryParse((String)buf.readUtf());
        int size = buf.readByte();
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (int i = 0; i < size; ++i) {
            ingredients.add((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
        }
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
        int sortNum = buf.readInt();
        return new AutoMechanicTableRecipe(category, ingredients, result, sortNum);
    }

    public static void toNetwork(RegistryFriendlyByteBuf buf, AutoMechanicTableRecipe recipe) {
        buf.writeUtf(recipe.category.toString());
        buf.writeByte(recipe.ingredients.size());
        recipe.ingredients.forEach(ing -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, ing));
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
        buf.writeInt(recipe.sortNum);
    }

    public MapCodec<AutoMechanicTableRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, AutoMechanicTableRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

