/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.neoforge.vendored.jsonem.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.foundationgames.automobility.neoforge.vendored.jsonem.JsonEM;
import io.github.foundationgames.automobility.neoforge.vendored.jsonem.serialization.JsonEMCodecs;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.neoforge.client.ClientHooks;

public final class JsonEntityModelUtil {
    public static final Gson GSON = new Gson();

    private JsonEntityModelUtil() {
    }

    public static Optional<LayerDefinition> readJson(InputStream data) {
        JsonElement json = (JsonElement)GSON.fromJson(GSON.newJsonReader((Reader)new InputStreamReader(data)), JsonObject.class);
        return JsonEMCodecs.LAYER_DEFINITION.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().map(Pair::getFirst);
    }

    public static void loadModels(ResourceManager manager, Map<ModelLayerLocation, LayerDefinition> layers) {
        ImmutableMap.Builder tempMap = new ImmutableMap.Builder();
        ClientHooks.loadLayerDefinitions((ImmutableMap.Builder)tempMap);
        FileToIdConverter.json((String)"models/entity").listMatchingResources(manager).forEach((id, res) -> {
            try {
                String fullPath = id.getPath().replaceFirst("models/entity/", "");
                String[] splitPath = fullPath.split("/");
                CharSequence[] dirs = new String[splitPath.length - 1];
                System.arraycopy(splitPath, 0, dirs, 0, dirs.length);
                String layerName = splitPath[splitPath.length - 1].replace(".json", "");
                String modelName = String.join((CharSequence)"/", dirs);
                ModelLayerLocation layer = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)modelName), layerName);
                try (InputStream in = res.open();){
                    Optional<LayerDefinition> data = JsonEntityModelUtil.readJson(in);
                    data.ifPresent(model -> layers.put(layer, (LayerDefinition)model));
                }
            }
            catch (IOException | ResourceLocationException ex) {
                JsonEM.LOG.error((Object)ex);
            }
        });
    }
}

