/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.neoforge;

import io.github.foundationgames.automobility.AutomobilityClient;
import io.github.foundationgames.automobility.automobile.render.AutomobileModels;
import io.github.foundationgames.automobility.automobile.render.obj.ObjLoader;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.block.model.SlopeBakedModel;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.neoforge.NeoForgePlatform;
import io.github.foundationgames.automobility.neoforge.block.render.NeoForgeSlopeBakedModel;
import io.github.foundationgames.automobility.neoforge.block.render.NeoForgeSlopeGeometryLoader;
import io.github.foundationgames.automobility.neoforge.block.render.SlopeModelsProvider;
import io.github.foundationgames.automobility.particle.AutomobilityParticles;
import io.github.foundationgames.automobility.particle.DriftSmokeParticle;
import io.github.foundationgames.automobility.screen.AutomobileHud;
import io.github.foundationgames.automobility.screen.MenuScreenRegistrar;
import io.github.foundationgames.automobility.util.Eventual;
import io.github.foundationgames.automobility.util.TriFunc;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="automobility", bus=EventBusSubscriber.Bus.MOD)
public class AutomobilityClientNeoForge {
    public static final AutomobileModels MODEL_DEF_LOADER = new AutomobileModels();

    @SubscribeEvent
    public static void initClient(FMLClientSetupEvent setup) {
        NeoForgePlatform.init();
        AutomobilityClient.init();
        SlopeBakedModel.impl = NeoForgeSlopeBakedModel::new;
        NeoForge.EVENT_BUS.addListener(evt -> {
            LocalPlayer player = Minecraft.getInstance().player;
            Entity patt0$temp = player.getVehicle();
            if (patt0$temp instanceof AutomobileEntity) {
                AutomobileEntity auto = (AutomobileEntity)patt0$temp;
                AutomobileHud.render(evt.getGuiGraphics(), (Player)player, auto, evt.getPartialTick().getGameTimeDeltaTicks());
            }
        });
        NeoForge.EVENT_BUS.addListener(evt -> evt.setFOV(AutomobilityClient.modifyBoostFov(Minecraft.getInstance(), evt.getFOV(), (float)evt.getPartialTick())));
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent evt) {
        evt.registerSpriteSet((ParticleType)AutomobilityParticles.DRIFT_SMOKE.require(), DriftSmokeParticle.Factory::new);
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block evt) {
        evt.register(AutomobilityClient.GRASS_COLOR, new Block[]{AutomobilityBlocks.GRASS_OFF_ROAD.require()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item evt) {
        evt.register(AutomobilityClient.GRASS_ITEM_COLOR, new ItemLike[]{(ItemLike)AutomobilityBlocks.GRASS_OFF_ROAD.require()});
    }

    @SubscribeEvent
    public static void registerMenuScreens(final RegisterMenuScreensEvent evt) {
        AutomobilityClient.initMenuScreens(new MenuScreenRegistrar(){

            @Override
            public <T extends AbstractContainerMenu, U extends Screen> void accept(Eventual<MenuType<T>> type, TriFunc<T, Inventory, Component, U> factory) {
                evt.register(type.require(), factory::apply);
            }
        });
    }

    @SubscribeEvent
    public static void registerResourceLoaders(RegisterClientReloadListenersEvent evt) {
        evt.registerReloadListener((PreparableReloadListener)MODEL_DEF_LOADER);
        evt.registerReloadListener((PreparableReloadListener)ObjLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerBakedModels(ModelEvent.RegisterGeometryLoaders evt) {
        evt.register(NeoForgeSlopeGeometryLoader.ID, (IGeometryLoader)NeoForgeSlopeGeometryLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void generateResources(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper files = evt.getExistingFileHelper();
        generator.addProvider(evt.includeClient(), (DataProvider)new SlopeModelsProvider(output, files));
    }
}

