/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.item;

import io.github.foundationgames.automobility.block.SlopeBlock;
import io.github.foundationgames.automobility.item.SlopePlacementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SlopeBlockItem
extends BlockItem {
    public SlopeBlockItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        Vec3 hitPos = context.getClickLocation();
        BlockPos pos = BlockPos.containing((Position)hitPos);
        Level world = context.getLevel();
        if (world.getBlockState(pos).getBlock() instanceof SlopeBlock) {
            Direction facing = (Direction)world.getBlockState(pos).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Half half = (Half)world.getBlockState(pos).getValue((Property)BlockStateProperties.HALF);
            Direction playerFacing = context.getHorizontalDirection();
            Direction vOffset = playerFacing == facing && half == Half.BOTTOM ? Direction.DOWN : (playerFacing == facing.getOpposite() && half == Half.TOP ? Direction.UP : null);
            BlockPos place = pos.relative(playerFacing);
            if (vOffset != null) {
                place = place.relative(vOffset);
            }
            BlockState pState = world.getBlockState(place);
            Half nHalf = half;
            if (playerFacing == facing || playerFacing == facing.getOpposite()) {
                Half half2 = nHalf = half == Half.TOP ? Half.BOTTOM : Half.TOP;
            }
            if (pState.isAir() || pState.is(Blocks.WATER)) {
                return new SlopePlacementContext((UseOnContext)BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)place, (Direction)Direction.UP), facing, nHalf);
            }
        }
        return super.updatePlacementContext(context);
    }
}

