/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.entity;

import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.entity.AutomobilityEntities;
import io.github.foundationgames.automobility.entity.EntityWithContainer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class HitboxEntity
extends Entity
implements EntityWithContainer {
    public static final EntityDataAccessor<Integer> AUTOMOBILE = SynchedEntityData.defineId(HitboxEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Vector3f> ORIGIN = SynchedEntityData.defineId(HitboxEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    public static final EntityDataAccessor<Float> WIDTH = SynchedEntityData.defineId(HitboxEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> HEIGHT = SynchedEntityData.defineId(HitboxEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private EntityDimensions size;

    public HitboxEntity(Level level, AutomobileEntity automobile, AutomobileFrame.Hitbox hitbox) {
        super(AutomobilityEntities.HITBOX.require(), level);
        this.entityData.set(AUTOMOBILE, (Object)automobile.getId());
        this.entityData.set(ORIGIN, (Object)new Vector3f((float)hitbox.origin().x(), (float)hitbox.origin().y(), (float)hitbox.origin().z()));
        this.entityData.set(WIDTH, (Object)Float.valueOf(hitbox.width()));
        this.entityData.set(HEIGHT, (Object)Float.valueOf(hitbox.height()));
        this.size = EntityDimensions.scalable((float)hitbox.width(), (float)hitbox.height());
    }

    public HitboxEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.size = EntityDimensions.scalable((float)1.1f, (float)0.7f);
    }

    public AutomobileEntity automobile() {
        Entity entity = this.level().getEntity(((Integer)this.entityData.get(AUTOMOBILE)).intValue());
        if (entity instanceof AutomobileEntity) {
            AutomobileEntity auto = (AutomobileEntity)entity;
            return auto;
        }
        return null;
    }

    public Vector3d boxOrigin() {
        Vector3f o = (Vector3f)this.entityData.get(ORIGIN);
        return new Vector3d((double)o.x(), (double)o.y(), (double)o.z());
    }

    public float width() {
        return this.size.width();
    }

    public float height() {
        return this.size.height();
    }

    public void tick() {
        AutomobileEntity automobile = this.automobile();
        if (automobile == null) {
            if (!this.level().isClientSide()) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (!this.level().isClientSide()) {
            if (!automobile.isAlive()) {
                this.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
        } else if (!automobile.hitboxes.contains(this)) {
            automobile.hitboxes.add(this);
        }
        Vector3d pos = this.boxOrigin();
        automobile.localPosToWorldSpace(pos);
        this.setPos(pos.x(), pos.y() - (double)this.size.height() * 0.5, pos.z());
        super.tick();
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.size;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        AutomobileEntity automobile = this.automobile();
        if (automobile == null) {
            return super.interact(player, hand);
        }
        return automobile.handleInteraction(player, hand);
    }

    @Nullable
    public ItemStack getPickResult() {
        AutomobileEntity automobile = this.automobile();
        if (automobile == null) {
            return super.getPickResult();
        }
        return automobile.asPrefabItem();
    }

    public Component getName() {
        AutomobileEntity auto = this.automobile();
        if (auto != null) {
            return auto.getName();
        }
        return super.getName();
    }

    public boolean canCollideWith(Entity other) {
        return !(other instanceof AutomobileEntity) && Boat.canVehicleCollide((Entity)this, (Entity)other);
    }

    public boolean canBeCollidedWith() {
        return this.level().isClientSide();
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
    }

    protected void lerpPositionAndRotationStep(int steps, double targetX, double targetY, double targetZ, double targetYRot, double targetXRot) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(AUTOMOBILE, (Object)Integer.MIN_VALUE);
        builder.define(ORIGIN, (Object)new Vector3f());
        builder.define(WIDTH, (Object)Float.valueOf(1.1f));
        builder.define(HEIGHT, (Object)Float.valueOf(0.7f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (WIDTH.equals(dataAccessor) || HEIGHT.equals(dataAccessor)) {
            this.size = EntityDimensions.scalable((float)((Float)this.entityData.get(WIDTH)).floatValue(), (float)((Float)this.entityData.get(HEIGHT)).floatValue());
            this.refreshDimensions();
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    @Override
    public Container underlyingContainer() {
        AutomobileEntity auto = this.automobile();
        if (auto != null) {
            return auto.underlyingContainer();
        }
        return null;
    }
}

