/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import com.mojang.serialization.MapCodec;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.block.DashPanelBlock;
import io.github.foundationgames.automobility.block.SlopeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class SlopeWithDashPanelBlock
extends SlopeBlock {
    public static final MapCodec<SlopeWithDashPanelBlock> CODEC = Block.simpleCodec(SlopeWithDashPanelBlock::new);

    public SlopeWithDashPanelBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)DashPanelBlock.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DashPanelBlock.POWERED});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, level, pos, block, fromPos, notify);
        boolean levelPwr = level.hasNeighborSignal(pos);
        boolean selfPwr = (Boolean)state.getValue((Property)DashPanelBlock.POWERED);
        if (levelPwr != selfPwr) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DashPanelBlock.POWERED, (Comparable)Boolean.valueOf(levelPwr)));
        }
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)AutomobilityBlocks.DASH_PANEL.require());
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.entityInside(state, world, pos, entity);
        DashPanelBlock.onCollideWithDashPanel(state, entity);
    }

    @Override
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

