/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class OffRoadBlock
extends Block {
    public static final VoxelShape ONE_LAYER_SHAPE = OffRoadBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape TWO_LAYER_SHAPE = OffRoadBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape THREE_LAYER_SHAPE = OffRoadBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final IntegerProperty LAYERS = IntegerProperty.create((String)"layers", (int)1, (int)3);
    public final Vector3f color;

    public OffRoadBlock(BlockBehaviour.Properties settings, Vector3f color) {
        super(settings.pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(1)));
        this.color = color;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        if (state.is((Block)this) && (Integer)state.getValue((Property)LAYERS) < 3) {
            return (BlockState)state.setValue((Property)LAYERS, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LAYERS) + 1));
        }
        return super.getStateForPlacement(ctx);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return (Integer)state.getValue((Property)LAYERS) < 3 && context.getItemInHand().is(this.asItem());
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, world, pos, block, fromPos, notify);
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos.below(), Direction.UP);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)LAYERS)) {
            case 2 -> TWO_LAYER_SHAPE;
            case 3 -> THREE_LAYER_SHAPE;
            default -> ONE_LAYER_SHAPE;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LAYERS});
    }
}

