/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.render.obj;

import de.javagl.obj.Obj;
import de.javagl.obj.ObjReader;
import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.automobile.render.obj.BakedObj;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ObjLoader
implements ResourceManagerReloadListener {
    public static ObjLoader INSTANCE = new ObjLoader();
    public static final ResourceLocation ID = Automobility.rl("obj_loader");
    public static final Logger LOG = LogManager.getLogger((String)"Automobility | OBJ Loader");
    private final Map<ModelLayerLocation, BakedObj> objs = new HashMap<ModelLayerLocation, BakedObj>();

    public Supplier<BakedObj> getObj(ModelLayerLocation location) {
        return new EventualObj(location);
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.objs.clear();
        new FileToIdConverter("models/entity", ".obj").listMatchingResources(resourceManager).forEach((rl, res) -> {
            try {
                String fullPath = rl.getPath().replaceFirst("models/entity/", "");
                String[] splitPath = fullPath.split("/");
                CharSequence[] dirs = new String[splitPath.length - 1];
                System.arraycopy(splitPath, 0, dirs, 0, dirs.length);
                String layerName = splitPath[splitPath.length - 1].replace(".obj", "");
                String modelName = String.join((CharSequence)"/", dirs);
                ModelLayerLocation layer = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)modelName), layerName);
                try (InputStream in = res.open();){
                    Obj obj = ObjReader.read((InputStream)in);
                    this.objs.put(layer, BakedObj.bake(obj));
                }
            }
            catch (IOException | ResourceLocationException ex) {
                LOG.error((Object)ex);
            }
        });
    }

    public class EventualObj
    implements Supplier<BakedObj> {
        public final ModelLayerLocation layer;
        @Nullable
        private BakedObj obj = null;

        public EventualObj(ModelLayerLocation layer) {
            this.layer = layer;
        }

        @Override
        public BakedObj get() {
            if (this.obj == null) {
                this.obj = ObjLoader.this.objs.get(this.layer);
            }
            return this.obj;
        }
    }
}

