/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.rear;

import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.rear.BaseChestRearAttachment;
import io.github.foundationgames.automobility.automobile.attachment.rear.BlockRearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ChestRearAttachment
extends BaseChestRearAttachment
implements Container,
MenuProvider {
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);

    public ChestRearAttachment(RearAttachmentType<?> type, AutomobileEntity entity, BlockState block, @Nullable BiFunction<ContainerLevelAccess, BlockRearAttachment, MenuProvider> screenProvider) {
        super(type, entity, block, screenProvider);
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        Vec3 pos = this.pos();
        this.inventory.forEach(s -> Containers.dropItemStack((Level)this.world(), (double)pos.x, (double)pos.y, (double)pos.z, (ItemStack)s));
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean isEmpty() {
        return this.inventory.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public void setChanged() {
        this.automobile.markDirty();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public Component getDisplayName() {
        return BaseChestRearAttachment.TITLE_CHEST;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return ChestMenu.threeRows((int)syncId, (Inventory)inv, (Container)this);
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public void startOpen(Player player) {
        this.open(player);
    }

    public void stopOpen(Player player) {
        this.close(player);
    }

    @Override
    protected SoundEvent getOpenSound() {
        return SoundEvents.CHEST_OPEN;
    }

    @Override
    protected SoundEvent getCloseSound() {
        return SoundEvents.CHEST_CLOSE;
    }

    @Override
    public void writeNbt(CompoundTag nbt, HolderLookup.Provider registry) {
        super.writeNbt(nbt, registry);
        nbt.put("Items", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inventory, (HolderLookup.Provider)registry));
    }

    @Override
    public void readNbt(CompoundTag nbt, HolderLookup.Provider registry) {
        super.readNbt(nbt, registry);
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("Items"), this.inventory, (HolderLookup.Provider)registry);
    }
}

