/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileStats;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record AutomobileData(Optional<ResourceLocation> prefabName, ResourceKey<AutomobileFrame> frame, ResourceKey<AutomobileWheel> wheel, ResourceKey<AutomobileEngine> engine) implements TooltipProvider
{
    public static final Codec<AutomobileData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ResourceLocation.CODEC.optionalFieldOf("prefab_id").forGetter(AutomobileData::prefabName), (App)AutomobileFrame.CODEC.fieldOf("frame").forGetter(AutomobileData::frame), (App)AutomobileWheel.CODEC.fieldOf("wheels").forGetter(AutomobileData::wheel), (App)AutomobileEngine.CODEC.fieldOf("engine").forGetter(AutomobileData::engine)).apply((Applicative)inst, AutomobileData::new));
    private static final AutomobileStats stats = new AutomobileStats();

    public static AutomobileData prefab(ResourceLocation prefabName, ResourceKey<AutomobileFrame> frame, ResourceKey<AutomobileWheel> wheel, ResourceKey<AutomobileEngine> engine) {
        return new AutomobileData(Optional.of(prefabName), frame, wheel, engine);
    }

    public ItemStack asStack() {
        ItemStack stack = AutomobilityItems.AUTOMOBILE.require().getDefaultInstance();
        stack.set(AutomobilityItems.COMPONENT_AUTOMOBILE_DATA.require(), (Object)this);
        if (this.prefabName().isPresent()) {
            ResourceLocation name = this.prefabName().get();
            stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)String.format("prefab.%s.%s", name.getNamespace(), name.getPath())));
        }
        return stack;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag tooltipFlag) {
        Optional frame = context.registries().lookupOrThrow(AutomobileFrame.REGISTRY).get(this.frame());
        Optional wheel = context.registries().lookupOrThrow(AutomobileWheel.REGISTRY).get(this.wheel());
        Optional engine = context.registries().lookupOrThrow(AutomobileEngine.REGISTRY).get(this.engine());
        if (Screen.hasShiftDown()) {
            stats.from(frame.map(Holder.Reference::value).orElse(AutomobileFrame.EMPTY), wheel.map(Holder.Reference::value).orElse(AutomobileWheel.EMPTY), engine.map(Holder.Reference::value).orElse(AutomobileEngine.EMPTY));
            stats.appendTexts(tooltip, stats);
        } else {
            if (this.prefabName().isEmpty()) {
                tooltip.accept((Component)Component.translatable((String)"tooltip.automobility.frameLabel").withStyle(ChatFormatting.BLUE).append((Component)Component.translatable((String)AutomobileFrame.getTranslationKey(this.frame().location())).withStyle(ChatFormatting.DARK_GREEN)));
                tooltip.accept((Component)Component.translatable((String)"tooltip.automobility.wheelLabel").withStyle(ChatFormatting.BLUE).append((Component)Component.translatable((String)AutomobileWheel.getTranslationKey(this.wheel().location())).withStyle(ChatFormatting.DARK_GREEN)));
                tooltip.accept((Component)Component.translatable((String)"tooltip.automobility.engineLabel").withStyle(ChatFormatting.BLUE).append((Component)Component.translatable((String)AutomobileEngine.getTranslationKey(this.engine().location())).withStyle(ChatFormatting.DARK_GREEN)));
            }
            tooltip.accept((Component)Component.translatable((String)"tooltip.automobility.shiftForStats").withStyle(ChatFormatting.GOLD));
        }
    }
}

