/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility;

import com.mojang.serialization.Codec;
import io.github.foundationgames.automobility.automobile.AutomobileEngine;
import io.github.foundationgames.automobility.automobile.AutomobileFrame;
import io.github.foundationgames.automobility.automobile.AutomobileWheel;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.entity.AutomobilityEntities;
import io.github.foundationgames.automobility.item.AutomobilityItems;
import io.github.foundationgames.automobility.item.CreativeTabQueue;
import io.github.foundationgames.automobility.particle.AutomobilityParticles;
import io.github.foundationgames.automobility.platform.Platform;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipe;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipeSerializer;
import io.github.foundationgames.automobility.screen.AutoMechanicTableScreenHandler;
import io.github.foundationgames.automobility.screen.SingleSlotScreenHandler;
import io.github.foundationgames.automobility.sound.AutomobilitySounds;
import io.github.foundationgames.automobility.util.AUtils;
import io.github.foundationgames.automobility.util.AutomobilityClientResourceDumper;
import io.github.foundationgames.automobility.util.DefaultRegistrar;
import io.github.foundationgames.automobility.util.Eventual;
import io.github.foundationgames.automobility.util.RegistryQueue;
import io.github.foundationgames.automobility.util.network.CommonPackets;
import java.io.IOException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Automobility {
    public static final String MOD_ID = "automobility";
    public static final Logger LOG = LogManager.getLogger((String)"Automobility");
    public static CreativeTabQueue TAB = new CreativeTabQueue(Automobility.rl("automobility"));
    public static CreativeTabQueue PREFAB_TAB = new CreativeTabQueue(Automobility.rl("automobility_prefabs"));
    public static final TagKey<Block> SLOPES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Automobility.rl("slopes"));
    public static final TagKey<Block> STEEP_SLOPES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Automobility.rl("steep_slopes"));
    public static final TagKey<Block> NON_STEEP_SLOPES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Automobility.rl("non_steep_slopes"));
    public static final TagKey<Block> STICKY_SLOPES = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Automobility.rl("sticky_slopes"));
    public static final Eventual<MenuType<AutoMechanicTableScreenHandler>> AUTO_MECHANIC_SCREEN = RegistryQueue.register(BuiltInRegistries.MENU, Automobility.rl("auto_mechanic_table"), () -> Platform.get().menuType(AutoMechanicTableScreenHandler::new));
    public static final Eventual<MenuType<SingleSlotScreenHandler>> SINGLE_SLOT_SCREEN = RegistryQueue.register(BuiltInRegistries.MENU, Automobility.rl("single_slot"), () -> Platform.get().menuType(SingleSlotScreenHandler::new));

    public static void init() {
        AutomobilitySounds.init();
        AutomobilityBlocks.init();
        AutomobilityItems.init();
        AutomobilityEntities.init();
        AutomobilityParticles.init();
        Automobility.initOther();
        CommonPackets.init();
    }

    public static void initOther() {
        RegistryQueue.register(BuiltInRegistries.RECIPE_TYPE, AutoMechanicTableRecipe.ID, () -> AutoMechanicTableRecipe.TYPE);
        RegistryQueue.register(BuiltInRegistries.RECIPE_SERIALIZER, AutoMechanicTableRecipe.ID, () -> AutoMechanicTableRecipeSerializer.INSTANCE);
        RegistryQueue.register(BuiltInRegistries.CREATIVE_MODE_TAB, Automobility.TAB.location, () -> Platform.get().creativeTab(Automobility.TAB.location, AUtils::createGroupIcon, TAB));
        RegistryQueue.register(BuiltInRegistries.CREATIVE_MODE_TAB, Automobility.PREFAB_TAB.location, () -> Platform.get().creativeTab(Automobility.PREFAB_TAB.location, AUtils::createPrefabsIcon, PREFAB_TAB));
        Platform.get().registerDataSerializer(AutomobileFrame.ID, AutomobileFrame.SERIALIZER);
        Platform.get().registerDataSerializer(AutomobileWheel.ID, AutomobileWheel.SERIALIZER);
        Platform.get().registerDataSerializer(AutomobileEngine.ID, AutomobileEngine.SERIALIZER);
    }

    public static void initDynamicRegistries(DynamicRegistryRegistrar handler) {
        handler.accept(AutomobileFrame.REGISTRY, AutomobileFrame.DIRECT_CODEC, AutomobileFrame.BOOTSTRAP);
        handler.accept(AutomobileWheel.REGISTRY, AutomobileWheel.DIRECT_CODEC, AutomobileWheel.BOOTSTRAP);
        handler.accept(AutomobileEngine.REGISTRY, AutomobileEngine.DIRECT_CODEC, AutomobileEngine.BOOTSTRAP);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void dumpDynamicRegistries(HolderLookup.Provider registries) throws IOException {
        AutomobilityClientResourceDumper.dumpDynamicRegistry(registries, AutomobileFrame.REGISTRY, AutomobileFrame.DIRECT_CODEC);
        AutomobilityClientResourceDumper.dumpDynamicRegistry(registries, AutomobileWheel.REGISTRY, AutomobileWheel.DIRECT_CODEC);
        AutomobilityClientResourceDumper.dumpDynamicRegistry(registries, AutomobileEngine.REGISTRY, AutomobileEngine.DIRECT_CODEC);
    }

    public static interface DynamicRegistryRegistrar {
        public <T> void accept(ResourceKey<Registry<T>> var1, Codec<T> var2, DefaultRegistrar<T> var3);
    }
}

