/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.snbt.SNBTBuilder;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.SNBTParser;
import dev.ftb.mods.ftblibrary.snbt.SNBTSyntaxException;
import dev.ftb.mods.ftblibrary.snbt.SNBTTagProperties;
import dev.ftb.mods.ftblibrary.snbt.SNBTUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class SNBT {
    private static boolean shouldSortKeysOnWrite = false;

    public static SNBTCompoundTag readLines(List<String> lines) {
        return SNBTParser.read(lines);
    }

    public static SNBTCompoundTag tryRead(Path path) throws IOException {
        return SNBT.readLines(Files.readAllLines(path, StandardCharsets.UTF_8));
    }

    public static void tryWrite(Path path, CompoundTag tag) throws IOException {
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.write(path, SNBT.writeLines(tag), new OpenOption[0]);
    }

    @Nullable
    public static SNBTCompoundTag read(Path path) {
        if (Files.notExists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0]) || !Files.isReadable(path)) {
            return null;
        }
        try {
            return SNBT.readLines(Files.readAllLines(path, StandardCharsets.UTF_8));
        }
        catch (SNBTSyntaxException ex) {
            FTBLibrary.LOGGER.error("Failed to read " + String.valueOf(path) + ": " + ex.getMessage());
            return null;
        }
        catch (Exception ex) {
            FTBLibrary.LOGGER.error("Failed to read " + String.valueOf(path) + ": " + String.valueOf(ex));
            ex.printStackTrace();
            return null;
        }
    }

    public static List<String> writeLines(CompoundTag nbt) {
        SNBTTagProperties rootProperties;
        SNBTBuilder builder = new SNBTBuilder();
        SNBTTagProperties sNBTTagProperties = rootProperties = nbt instanceof SNBTCompoundTag ? ((SNBTCompoundTag)nbt).getProperties("") : SNBTTagProperties.DEFAULT;
        if (!rootProperties.comment.isEmpty()) {
            for (String s : rootProperties.comment.split("\n")) {
                builder.print("# ");
                builder.print(s);
                builder.println();
            }
            builder.println();
        }
        SNBT.append(builder, (Tag)nbt);
        builder.println();
        return builder.lines;
    }

    public static boolean write(Path path, CompoundTag nbt) {
        try {
            if (Files.notExists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            Files.write(path, SNBT.writeLines(nbt), new OpenOption[0]);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static void append(SNBTBuilder builder, @Nullable Tag nbt) {
        if (nbt == null || nbt instanceof EndTag) {
            builder.print("null");
        } else if (nbt instanceof CompoundTag) {
            SNBTCompoundTag s;
            SNBTCompoundTag snbtCompoundTag;
            CompoundTag compound = (CompoundTag)nbt;
            SNBTCompoundTag sNBTCompoundTag = snbtCompoundTag = compound instanceof SNBTCompoundTag ? (s = (SNBTCompoundTag)compound) : null;
            if (compound.isEmpty()) {
                builder.print("{ }");
                return;
            }
            if (snbtCompoundTag != null && snbtCompoundTag.singleLine) {
                ++builder.singleLine;
            }
            boolean singleLine = builder.singleLine > 0;
            builder.print("{");
            if (singleLine) {
                builder.print(" ");
            } else {
                builder.println();
                builder.push();
            }
            int index = 0;
            Set keys = shouldSortKeysOnWrite ? compound.getAllKeys().stream().sorted().toList() : compound.getAllKeys();
            for (String key : keys) {
                SNBTTagProperties properties;
                ++index;
                SNBTTagProperties sNBTTagProperties = properties = snbtCompoundTag == null ? SNBTTagProperties.DEFAULT : snbtCompoundTag.getProperties(key);
                if (!properties.comment.isEmpty()) {
                    if (singleLine) {
                        throw new IllegalStateException("Can't have singleLine enabled and a comment at the same time!");
                    }
                    if (index != 1) {
                        builder.println();
                    }
                    for (String s2 : properties.comment.split("\n")) {
                        builder.print("# ");
                        builder.print(s2);
                        builder.println();
                    }
                }
                builder.print(SNBTUtils.handleEscape(key));
                builder.print(": ");
                if (properties.valueType == 1) {
                    builder.print("false");
                } else if (properties.valueType == 2) {
                    builder.print("true");
                } else {
                    if (properties.singleLine) {
                        ++builder.singleLine;
                    }
                    SNBT.append(builder, compound.get(key));
                    if (properties.singleLine) {
                        --builder.singleLine;
                    }
                }
                if (singleLine && index != compound.size()) {
                    builder.print(",");
                }
                if (singleLine) {
                    builder.print(" ");
                    continue;
                }
                builder.println();
            }
            if (!singleLine) {
                builder.pop();
            }
            builder.print("}");
            if (snbtCompoundTag != null && snbtCompoundTag.singleLine) {
                --builder.singleLine;
            }
        } else if (nbt instanceof CollectionTag) {
            if (nbt instanceof ByteArrayTag) {
                SNBT.appendCollection(builder, (CollectionTag<? extends Tag>)((CollectionTag)nbt), "B;");
            } else if (nbt instanceof IntArrayTag) {
                SNBT.appendCollection(builder, (CollectionTag<? extends Tag>)((CollectionTag)nbt), "I;");
            } else if (nbt instanceof LongArrayTag) {
                SNBT.appendCollection(builder, (CollectionTag<? extends Tag>)((CollectionTag)nbt), "L;");
            } else {
                SNBT.appendCollection(builder, (CollectionTag<? extends Tag>)((CollectionTag)nbt), "");
            }
        } else if (nbt instanceof StringTag) {
            builder.print(SNBTUtils.quoteAndEscape(nbt.getAsString()));
        } else {
            builder.print(nbt.toString());
        }
    }

    private static void appendCollection(SNBTBuilder builder, CollectionTag<? extends Tag> nbt, String opening) {
        if (nbt.isEmpty()) {
            builder.print("[");
            builder.print(opening);
            builder.print(" ]");
            return;
        }
        if (nbt.size() == 1) {
            builder.print("[");
            builder.print(opening);
            SNBT.append(builder, (Tag)nbt.get(0));
            builder.print("]");
            return;
        }
        boolean singleLine = builder.singleLine > 0;
        builder.print("[");
        builder.print(opening);
        if (singleLine) {
            builder.print(" ");
        } else {
            builder.println();
            builder.push();
        }
        int index = 0;
        for (Tag value : nbt) {
            SNBT.append(builder, value);
            if (singleLine && ++index != nbt.size()) {
                builder.print(",");
            }
            if (singleLine) {
                builder.print(" ");
                continue;
            }
            builder.println();
        }
        if (!singleLine) {
            builder.pop();
        }
        builder.print("]");
    }

    public static boolean shouldSortKeysOnWrite() {
        return shouldSortKeysOnWrite;
    }

    public static boolean setShouldSortKeysOnWrite(boolean shouldSortKeysOnWrite) {
        boolean prev = SNBT.shouldSortKeysOnWrite;
        SNBT.shouldSortKeysOnWrite = shouldSortKeysOnWrite;
        return prev;
    }
}

