/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.ftb.mods.ftblibrary.config.manager.ConfigManagerClient;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.net.EditConfigChoicePacket;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ChooseConfigScreen
extends BaseScreen {
    private static final int BTN_HEIGHT = 22;
    private final EditConfigChoicePacket message;

    private ChooseConfigScreen(EditConfigChoicePacket message) {
        this.message = message;
    }

    public static void open(EditConfigChoicePacket message) {
        new ChooseConfigScreen(message).openGui();
    }

    @Override
    public void addWidgets() {
        this.add(new TextField(this).setText(this.message.title()).addFlags(6));
        this.add(new TextButton(this, (Component)Component.translatable((String)"ftblibrary.client_settings"), Icons.PLAYER, (widget, button) -> ConfigManagerClient.editConfig(this.message.clientConfig())));
        this.add(new TextButton(this, (Component)Component.translatable((String)"ftblibrary.server_settings"), Icons.GLOBE, (widget, button) -> ConfigManagerClient.editConfig(this.message.serverConfig())));
        this.add(new TextButton(this, CommonComponents.GUI_BACK, Icons.BACK, (widget, button) -> this.closeGui()));
    }

    @Override
    public void alignWidgets() {
        int ySize = 76;
        int xSize = 50 + this.widgets.stream().map(w -> this.getTheme().getStringWidth((FormattedText)w.getTitle())).max(Integer::compare).orElse(100);
        int yPos = (this.getScreen().getGuiScaledHeight() - ySize) / 2;
        for (Widget w2 : this.widgets) {
            w2.setPosAndSize((this.getScreen().getGuiScaledWidth() - xSize) / 2, yPos, xSize, 22);
            yPos += 27;
        }
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
    }

    private static class TextButton
    extends SimpleTextButton {
        private final Callback callback;

        public TextButton(Panel panel, Component txt, Icon icon, Callback callback) {
            super(panel, txt, icon);
            this.callback = callback;
        }

        @Override
        public void onClicked(MouseButton button) {
            this.callback.onClicked(this, button);
        }

        @Override
        public boolean renderTitleInCenter() {
            return true;
        }

        public static interface Callback {
            public void onClicked(TextButton var1, MouseButton var2);
        }
    }
}

