/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.biome;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.util.biome.BiomeUtil;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;

public class BOPOverworldBiomeBuilder {
    private static final float VALLEY_SIZE = 0.05f;
    private static final float LOW_START = 0.26666668f;
    public static final float HIGH_START = 0.4f;
    private static final float HIGH_END = 0.93333334f;
    private static final float PEAK_SIZE = 0.1f;
    public static final float PEAK_START = 0.56666666f;
    private static final float PEAK_END = 0.7666667f;
    public static final float NEAR_INLAND_START = -0.11f;
    public static final float MID_INLAND_START = 0.03f;
    public static final float FAR_INLAND_START = 0.3f;
    public static final float EROSION_INDEX_1_START = -0.78f;
    public static final float EROSION_INDEX_2_START = -0.375f;
    protected final Climate.Parameter FULL_RANGE = Climate.Parameter.span((float)-1.0f, (float)1.0f);
    protected final Climate.Parameter[] temperatures = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.45f), Climate.Parameter.span((float)-0.45f, (float)-0.15f), Climate.Parameter.span((float)-0.15f, (float)0.2f), Climate.Parameter.span((float)0.2f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    protected final Climate.Parameter[] humidities = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.35f), Climate.Parameter.span((float)-0.35f, (float)-0.1f), Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)0.1f, (float)0.3f), Climate.Parameter.span((float)0.3f, (float)1.0f)};
    protected final Climate.Parameter[] erosions = new Climate.Parameter[]{Climate.Parameter.span((float)-1.0f, (float)-0.78f), Climate.Parameter.span((float)-0.78f, (float)-0.375f), Climate.Parameter.span((float)-0.375f, (float)-0.2225f), Climate.Parameter.span((float)-0.2225f, (float)0.05f), Climate.Parameter.span((float)0.05f, (float)0.45f), Climate.Parameter.span((float)0.45f, (float)0.55f), Climate.Parameter.span((float)0.55f, (float)1.0f)};
    protected static final Climate.Parameter COMMON_RARENESS_RANGE = Climate.Parameter.span((float)-1.0f, (float)0.35f);
    protected static final Climate.Parameter RARE_RARENESS_RANGE = Climate.Parameter.span((float)0.35f, (float)1.0f);
    protected final Climate.Parameter FROZEN_RANGE = this.temperatures[0];
    protected final Climate.Parameter UNFROZEN_RANGE = Climate.Parameter.span((Climate.Parameter)this.temperatures[1], (Climate.Parameter)this.temperatures[4]);
    protected final Climate.Parameter mushroomFieldsContinentalness = Climate.Parameter.span((float)-1.2f, (float)-1.05f);
    protected final Climate.Parameter deepOceanContinentalness = Climate.Parameter.span((float)-1.05f, (float)-0.455f);
    protected final Climate.Parameter oceanContinentalness = Climate.Parameter.span((float)-0.455f, (float)-0.19f);
    protected final Climate.Parameter coastContinentalness = Climate.Parameter.span((float)-0.19f, (float)-0.11f);
    protected final Climate.Parameter inlandContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.55f);
    protected final Climate.Parameter nearInlandContinentalness = Climate.Parameter.span((float)-0.11f, (float)0.03f);
    protected final Climate.Parameter midInlandContinentalness = Climate.Parameter.span((float)0.03f, (float)0.3f);
    protected final Climate.Parameter farInlandContinentalness = Climate.Parameter.span((float)0.3f, (float)1.0f);
    private final ResourceKey<Biome>[][] OCEANS = new ResourceKey[][]{{Biomes.DEEP_FROZEN_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.DEEP_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.WARM_OCEAN}, {Biomes.FROZEN_OCEAN, Biomes.COLD_OCEAN, Biomes.OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.WARM_OCEAN}};
    protected final ResourceKey<Biome>[][] MIDDLE_BIOMES = new ResourceKey[][]{{Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_TAIGA, Biomes.TAIGA}, {Biomes.PLAINS, Biomes.PLAINS, Biomes.FOREST, Biomes.TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA}, {Biomes.FLOWER_FOREST, Biomes.PLAINS, Biomes.FOREST, Biomes.BIRCH_FOREST, Biomes.DARK_FOREST}, {Biomes.SAVANNA, Biomes.SAVANNA, Biomes.FOREST, Biomes.JUNGLE, Biomes.JUNGLE}, {Biomes.DESERT, Biomes.DESERT, Biomes.DESERT, Biomes.DESERT, Biomes.DESERT}};
    private final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, Biomes.SNOWY_TAIGA, null, null}, {null, null, null, null, Biomes.OLD_GROWTH_PINE_TAIGA}, {Biomes.SUNFLOWER_PLAINS, null, null, Biomes.OLD_GROWTH_BIRCH_FOREST, null}, {null, null, Biomes.PLAINS, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}, {null, null, null, null, null}};
    protected final ResourceKey<Biome>[][] PLATEAU_BIOMES = new ResourceKey[][]{{Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_PLAINS, Biomes.SNOWY_TAIGA, Biomes.SNOWY_TAIGA}, {Biomes.MEADOW, Biomes.MEADOW, Biomes.FOREST, Biomes.TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA}, {Biomes.MEADOW, Biomes.MEADOW, Biomes.MEADOW, Biomes.MEADOW, Biomes.DARK_FOREST}, {Biomes.SAVANNA_PLATEAU, Biomes.SAVANNA_PLATEAU, Biomes.FOREST, Biomes.FOREST, Biomes.JUNGLE}, {Biomes.BADLANDS, Biomes.BADLANDS, Biomes.BADLANDS, Biomes.WOODED_BADLANDS, Biomes.WOODED_BADLANDS}};
    protected final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT = new ResourceKey[][]{{Biomes.ICE_SPIKES, null, null, null, null}, {Biomes.CHERRY_GROVE, null, Biomes.MEADOW, Biomes.MEADOW, Biomes.OLD_GROWTH_PINE_TAIGA}, {Biomes.CHERRY_GROVE, Biomes.CHERRY_GROVE, Biomes.FOREST, Biomes.BIRCH_FOREST, null}, {null, null, null, null, null}, {Biomes.ERODED_BADLANDS, Biomes.ERODED_BADLANDS, null, null, null}};
    private final ResourceKey<Biome>[][] EXTREME_HILLS_BIOMES = new ResourceKey[][]{{Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_HILLS, Biomes.WINDSWEPT_FOREST, Biomes.WINDSWEPT_FOREST}, {null, null, null, null, null}, {null, null, null, null, null}};
    private final ResourceKey<Biome>[][] SWAMP_BIOMES = new ResourceKey[][]{{Biomes.FROZEN_RIVER, Biomes.FROZEN_RIVER, Biomes.FROZEN_RIVER, Biomes.FROZEN_RIVER, Biomes.FROZEN_RIVER}, {Biomes.SWAMP, Biomes.SWAMP, Biomes.SWAMP, Biomes.SWAMP, Biomes.SWAMP}, {Biomes.SWAMP, Biomes.SWAMP, Biomes.SWAMP, Biomes.SWAMP, Biomes.SWAMP}, {Biomes.MANGROVE_SWAMP, Biomes.MANGROVE_SWAMP, Biomes.MANGROVE_SWAMP, Biomes.MANGROVE_SWAMP, Biomes.MANGROVE_SWAMP}, {Biomes.MANGROVE_SWAMP, Biomes.MANGROVE_SWAMP, Biomes.MANGROVE_SWAMP, Biomes.MANGROVE_SWAMP, Biomes.MANGROVE_SWAMP}};
    protected final ResourceKey<Biome>[][] BEACH_BIOMES = new ResourceKey[][]{{Biomes.SNOWY_BEACH, Biomes.SNOWY_BEACH, Biomes.SNOWY_BEACH, Biomes.SNOWY_BEACH, Biomes.SNOWY_BEACH}, {Biomes.BEACH, Biomes.BEACH, Biomes.BEACH, Biomes.BEACH, Biomes.BEACH}, {Biomes.BEACH, Biomes.BEACH, Biomes.BEACH, Biomes.BEACH, Biomes.BEACH}, {Biomes.BEACH, Biomes.BEACH, Biomes.BEACH, Biomes.BEACH, Biomes.BEACH}, {Biomes.DESERT, Biomes.DESERT, Biomes.DESERT, Biomes.DESERT, Biomes.DESERT}};
    protected final ResourceKey<Biome>[][] MIDDLE_BIOMES_BOP = new ResourceKey[][]{{BOPBiomes.COLD_DESERT, BOPBiomes.COLD_DESERT, BOPBiomes.SNOWY_CONIFEROUS_FOREST, BOPBiomes.SNOWY_CONIFEROUS_FOREST, BOPBiomes.SNOWY_CONIFEROUS_FOREST}, {BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.FIELD, BOPBiomes.FIELD}, {BOPBiomes.PASTURE, BOPBiomes.PRAIRIE, BOPBiomes.REDWOOD_FOREST, BOPBiomes.OVERGROWN_GREENS, BOPBiomes.OVERGROWN_GREENS}, {BOPBiomes.SCRUBLAND, BOPBiomes.SCRUBLAND, BOPBiomes.WOODLAND, BOPBiomes.RAINFOREST, BOPBiomes.RAINFOREST}, {BOPBiomes.DRYLAND, BOPBiomes.DRYLAND, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT}};
    protected final ResourceKey<Biome>[][] MIDDLE_BIOMES_VARIANT_BOP = new ResourceKey[][]{{null, null, BOPBiomes.SNOWY_FIR_CLEARING, BOPBiomes.SNOWY_FIR_CLEARING, BOPBiomes.SNOWY_MAPLE_WOODS}, {null, BOPBiomes.FIR_CLEARING, null, null, BOPBiomes.FORESTED_FIELD}, {null, null, null, null, BOPBiomes.GRASSLAND}, {null, null, BOPBiomes.OLD_GROWTH_WOODLAND, null, BOPBiomes.ROCKY_RAINFOREST}, {null, null, null, BOPBiomes.LUSH_SAVANNA, BOPBiomes.LUSH_SAVANNA}};
    protected final ResourceKey<Biome>[][] PLATEAU_BIOMES_BOP = new ResourceKey[][]{{BOPBiomes.COLD_DESERT, BOPBiomes.COLD_DESERT, BOPBiomes.SNOWY_FIR_CLEARING, BOPBiomes.SNOWY_FIR_CLEARING, BOPBiomes.SNOWY_CONIFEROUS_FOREST}, {BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.FIELD}, {BOPBiomes.PRAIRIE, BOPBiomes.PRAIRIE, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND}, {BOPBiomes.SCRUBLAND, BOPBiomes.SCRUBLAND, BOPBiomes.WOODLAND, BOPBiomes.RAINFOREST, BOPBiomes.ROCKY_RAINFOREST}, {BOPBiomes.DRYLAND, BOPBiomes.DRYLAND, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT}};
    protected final ResourceKey<Biome>[][] PLATEAU_BIOMES_VARIANT_BOP = new ResourceKey[][]{{null, null, null, null, null}, {null, null, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.FIELD, null}, {BOPBiomes.PASTURE, null, BOPBiomes.REDWOOD_FOREST, BOPBiomes.OVERGROWN_GREENS, BOPBiomes.MOOR}, {null, null, null, BOPBiomes.ROCKY_RAINFOREST, null}, {null, null, null, null, BOPBiomes.LUSH_SAVANNA}};
    protected final ResourceKey<Biome>[][] SLOPE_BIOMES_BOP = new ResourceKey[][]{{null, null, null, null, null}, {BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG}, {BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS}, {null, null, null, BOPBiomes.VOLCANO, BOPBiomes.VOLCANO}, {null, null, null, null, null}};
    protected final ResourceKey<Biome>[][] PEAK_BIOMES_BOP = new ResourceKey[][]{{null, null, null, null, null}, {BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG}, {BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS}, {null, null, null, BOPBiomes.VOLCANO, BOPBiomes.VOLCANO}, {null, null, null, null, null}};
    protected final ResourceKey<Biome>[][] EXTREME_HILLS_BIOMES_BOP = new ResourceKey[][]{{null, null, null, null, null}, {BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND}, {BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND}, {null, null, null, BOPBiomes.VOLCANO, BOPBiomes.VOLCANO}, {null, null, null, null, null}};
    protected final ResourceKey<Biome>[][] SWAMP_BIOMES_BOP = new ResourceKey[][]{{BOPBiomes.HOT_SPRINGS, BOPBiomes.HOT_SPRINGS, BOPBiomes.HOT_SPRINGS, BOPBiomes.HOT_SPRINGS, BOPBiomes.HOT_SPRINGS}, {BOPBiomes.WETLAND, BOPBiomes.WETLAND, BOPBiomes.WETLAND, BOPBiomes.WETLAND, BOPBiomes.WETLAND}, {BOPBiomes.MARSH, BOPBiomes.MARSH, BOPBiomes.MARSH, BOPBiomes.MARSH, BOPBiomes.MARSH}, {BOPBiomes.BAYOU, BOPBiomes.BAYOU, BOPBiomes.BAYOU, BOPBiomes.FLOODPLAIN, BOPBiomes.FLOODPLAIN}, {BOPBiomes.BAYOU, BOPBiomes.BAYOU, BOPBiomes.BAYOU, BOPBiomes.FLOODPLAIN, BOPBiomes.FLOODPLAIN}};
    protected final ResourceKey<Biome>[][] RIVER_BIOMES_BOP = new ResourceKey[][]{{Biomes.FROZEN_RIVER, Biomes.FROZEN_RIVER, Biomes.FROZEN_RIVER, Biomes.FROZEN_RIVER, Biomes.FROZEN_RIVER}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, BOPBiomes.FLOODPLAIN, BOPBiomes.FLOODPLAIN}, {null, null, null, null, null}};
    protected final ResourceKey<Biome>[][] BEACH_BIOMES_BOP = new ResourceKey[][]{{Biomes.SNOWY_BEACH, Biomes.SNOWY_BEACH, Biomes.SNOWY_BEACH, Biomes.SNOWY_BEACH, Biomes.SNOWY_BEACH}, {BOPBiomes.GRAVEL_BEACH, BOPBiomes.GRAVEL_BEACH, BOPBiomes.GRAVEL_BEACH, BOPBiomes.GRAVEL_BEACH, BOPBiomes.GRAVEL_BEACH}, {BOPBiomes.DUNE_BEACH, BOPBiomes.DUNE_BEACH, BOPBiomes.DUNE_BEACH, Biomes.BEACH, Biomes.BEACH}, {Biomes.BEACH, Biomes.BEACH, Biomes.BEACH, BOPBiomes.FLOODPLAIN, BOPBiomes.FLOODPLAIN}, {BOPBiomes.DRYLAND, BOPBiomes.DRYLAND, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT}};
    protected final ResourceKey<Biome>[][] STONY_SHORES_BIOMES_BOP = new ResourceKey[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, BOPBiomes.ROCKY_RAINFOREST, BOPBiomes.ROCKY_RAINFOREST}, {null, null, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT}};
    protected final ResourceKey<Biome>[][] ISLAND_BIOMES_BOP = new ResourceKey[][]{{BOPBiomes.WINTRY_ORIGIN_VALLEY, BOPBiomes.WINTRY_ORIGIN_VALLEY, BOPBiomes.WINTRY_ORIGIN_VALLEY, BOPBiomes.WINTRY_ORIGIN_VALLEY, BOPBiomes.WINTRY_ORIGIN_VALLEY}, {BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY}, {null, null, null, null, null}, {BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS}, {BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS}};

    public void addBiomes(Registry<Biome> biomeRegistry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addOffCoastBiomes(biomeRegistry, mapper);
        this.addInlandBiomes(biomeRegistry, mapper);
        this.addUndergroundBiomes(biomeRegistry, mapper);
    }

    private void addOffCoastBiomes(Registry<Biome> biomeRegistry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> islandBiomeBOP = this.pickIslandBiomeBOP(biomeRegistry, i, j);
                this.addSurfaceBiome(mapper, temperature, humidity, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, islandBiomeBOP);
            }
            this.addSurfaceBiome(mapper, temperature, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[0][i]);
            this.addSurfaceBiome(mapper, temperature, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[1][i]);
        }
    }

    private void addInlandBiomes(Registry<Biome> biomeRegistry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addMidSlice(biomeRegistry, mapper, Climate.Parameter.span((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(biomeRegistry, mapper, Climate.Parameter.span((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(biomeRegistry, mapper, Climate.Parameter.span((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(biomeRegistry, mapper, Climate.Parameter.span((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(biomeRegistry, mapper, Climate.Parameter.span((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(biomeRegistry, mapper, Climate.Parameter.span((float)-0.26666668f, (float)-0.05f));
        this.addValleys(biomeRegistry, mapper, Climate.Parameter.span((float)-0.05f, (float)0.05f));
        this.addLowSlice(biomeRegistry, mapper, Climate.Parameter.span((float)0.05f, (float)0.26666668f));
        this.addMidSlice(biomeRegistry, mapper, Climate.Parameter.span((float)0.26666668f, (float)0.4f));
        this.addHighSlice(biomeRegistry, mapper, Climate.Parameter.span((float)0.4f, (float)0.56666666f));
        this.addPeaks(biomeRegistry, mapper, Climate.Parameter.span((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(biomeRegistry, mapper, Climate.Parameter.span((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(biomeRegistry, mapper, Climate.Parameter.span((float)0.93333334f, (float)1.0f));
    }

    protected void addPeaks(Registry<Biome> biomeRegistry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> plateauBiomeBOP = this.pickPlateauBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiome = this.pickExtremeHillsBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiomeBOP = this.pickExtremeHillsBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(biomeRegistry, i, j, weirdness, extremeHillsBiome);
                ResourceKey<Biome> peakBiomeBOP = this.pickPeakBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, peakBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiomeBOP);
            }
        }
    }

    protected void addHighSlice(Registry<Biome> biomeRegistry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> plateauBiomeBOP = this.pickPlateauBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiomeBOP = this.pickExtremeHillsBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(biomeRegistry, i, j, weirdness, middleBiomeVanilla);
                ResourceKey<Biome> slopeBiomeBOP = this.pickSlopeBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> peakBiomeBOP = this.pickPeakBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[0], weirdness, 0.0f, slopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, slopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiomeBOP);
            }
        }
    }

    protected void addMidSlice(Registry<Biome> biomeRegistry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> extremeHillsBiomeBOP = this.pickExtremeHillsBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> plateauBiomeBOP = this.pickPlateauBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> beachBiomeBOP = this.pickBeachBiomeBOP(biomeRegistry, i, j);
                ResourceKey<Biome> stonyShoresBiomeBOP = this.pickStonyShoresBiomeBOP(biomeRegistry, i, j);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(biomeRegistry, i, j, weirdness, middleBiomeVanilla);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> slopeBiomeBOP = this.pickSlopeBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> swampBiomeBOP = this.pickSwampBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stonyShoresBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, slopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.midInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[1], weirdness, 0.0f, i == 0 ? slopeBiomeBOP : plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[2], weirdness, 0.0f, plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.nearInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiomeBOP);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[4], weirdness, 0.0f, beachBiomeBOP);
                    this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeBOP);
                } else {
                    this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeBOP);
                }
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiomeBOP);
                if (weirdness.max() < 0L) {
                    this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiomeBOP);
                } else {
                    this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, middleBiomeBOP);
                }
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiomeBOP);
            }
        }
    }

    protected void addLowSlice(Registry<Biome> biomeRegistry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            Climate.Parameter temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                Climate.Parameter humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                ResourceKey<Biome> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> beachBiome = this.pickBeachBiomeBOP(biomeRegistry, i, j);
                ResourceKey<Biome> stonyShoresBiomeBOP = this.pickStonyShoresBiomeBOP(biomeRegistry, i, j);
                ResourceKey<Biome> shatteredBiome = this.maybePickShatteredBiome(biomeRegistry, i, j, weirdness, middleBiomeVanilla);
                ResourceKey<Biome> shatteredCoastBiome = this.pickShatteredCoastBiome(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> swampBiomeBOP = this.pickSwampBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[2]), weirdness, 0.0f, stonyShoresBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBadlandsOrSlopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[3]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[3], (Climate.Parameter)this.erosions[4]), weirdness, 0.0f, beachBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.nearInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiomeBOP);
            }
        }
    }

    protected void addValleys(Registry<Biome> biomeRegistry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter weirdness) {
        Climate.Parameter humidity;
        int j;
        Climate.Parameter temperature;
        int i;
        for (i = 0; i < this.temperatures.length; ++i) {
            temperature = this.temperatures[i];
            for (j = 0; j < this.humidities.length; ++j) {
                humidity = this.humidities[j];
                ResourceKey<Biome> riverBiomeBOP = this.pickRiverBiomeBOP(biomeRegistry, i, j);
                ResourceKey<Biome> stonyShoresBiomeBOP = this.pickStonyShoresBiomeBOP(biomeRegistry, i, j);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, weirdness.max() < 0L ? stonyShoresBiomeBOP : riverBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, riverBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.coastContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[2], (Climate.Parameter)this.erosions[5]), weirdness, 0.0f, riverBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, riverBiomeBOP);
            }
        }
        for (i = 0; i < this.temperatures.length; ++i) {
            temperature = this.temperatures[i];
            for (j = 0; j < this.humidities.length; ++j) {
                humidity = this.humidities[j];
                ResourceKey<Biome> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                ResourceKey<Biome> swampBiomeBOP = this.pickSwampBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.midInlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, Climate.Parameter.span((Climate.Parameter)this.inlandContinentalness, (Climate.Parameter)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiomeBOP);
            }
        }
    }

    protected void addUndergroundBiomes(Registry<Biome> biomeRegistry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addUndergroundBiome(biomeRegistry, mapper, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, BOPBiomes.SPIDER_NEST, (ResourceKey<Biome>)Biomes.DRIPSTONE_CAVES);
        this.addUndergroundBiome(biomeRegistry, mapper, this.FULL_RANGE, Climate.Parameter.span((float)0.7f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, 0.0f, BOPBiomes.GLOWING_GROTTO, (ResourceKey<Biome>)Biomes.LUSH_CAVES);
        this.addBottomBiome(mapper, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, Climate.Parameter.span((Climate.Parameter)this.erosions[0], (Climate.Parameter)this.erosions[1]), this.FULL_RANGE, 0.0f, (ResourceKey<Biome>)Biomes.DEEP_DARK);
    }

    protected ResourceKey<Biome> pickMiddleBiomeVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (weirdness.max() < 0L) {
            return this.MIDDLE_BIOMES[temperatureIndex][humidityIndex];
        }
        ResourceKey<Biome> variantBiome = this.MIDDLE_BIOMES_VARIANT[temperatureIndex][humidityIndex];
        return variantBiome == null ? this.MIDDLE_BIOMES[temperatureIndex][humidityIndex] : variantBiome;
    }

    protected ResourceKey<Biome> pickMiddleBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> middleBiome = BiomeUtil.biomeOrFallback(biomeRegistry, this.MIDDLE_BIOMES_BOP[temperatureIndex][humidityIndex], this.MIDDLE_BIOMES[temperatureIndex][humidityIndex]);
        if (weirdness.max() < 0L) {
            return middleBiome;
        }
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.MIDDLE_BIOMES_VARIANT_BOP[temperatureIndex][humidityIndex], middleBiome);
    }

    protected ResourceKey<Biome> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return temperatureIndex == 0 ? this.pickSlopeBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness) : this.pickMiddleBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness);
    }

    protected ResourceKey<Biome> maybePickShatteredBiome(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness, ResourceKey<Biome> extremeHillsBiome) {
        return temperatureIndex > 1 && humidityIndex < 4 && weirdness.max() >= 0L ? BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.CRAG, Biomes.WINDSWEPT_SAVANNA) : extremeHillsBiome;
    }

    protected ResourceKey<Biome> pickShatteredCoastBiome(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourcekey = weirdness.max() >= 0L ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : this.pickBeachBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex);
        return this.maybePickShatteredBiome(biomeRegistry, temperatureIndex, humidityIndex, weirdness, resourcekey);
    }

    protected ResourceKey<Biome> pickSwampBiomeVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourcekey = this.SWAMP_BIOMES[temperatureIndex][humidityIndex];
        return resourcekey == null ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : resourcekey;
    }

    protected ResourceKey<Biome> pickSwampBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.SWAMP_BIOMES_BOP[temperatureIndex][humidityIndex], this.pickSwampBiomeVanilla(temperatureIndex, humidityIndex, weirdness));
    }

    protected ResourceKey<Biome> pickRiverBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.RIVER_BIOMES_BOP[temperatureIndex][humidityIndex], temperatureIndex == 0 ? Biomes.FROZEN_RIVER : Biomes.RIVER);
    }

    protected ResourceKey<Biome> pickBeachBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.BEACH_BIOMES_BOP[temperatureIndex][humidityIndex], this.BEACH_BIOMES[temperatureIndex][humidityIndex]);
    }

    protected ResourceKey<Biome> pickStonyShoresBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.STONY_SHORES_BIOMES_BOP[temperatureIndex][humidityIndex], Biomes.STONY_SHORE);
    }

    protected ResourceKey<Biome> pickIslandBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.ISLAND_BIOMES_BOP[temperatureIndex][humidityIndex], Biomes.MUSHROOM_FIELDS);
    }

    protected ResourceKey<Biome> pickBadlandsBiome(int humidityIndex, Climate.Parameter weirdness) {
        if (humidityIndex < 2) {
            return weirdness.max() < 0L ? Biomes.ERODED_BADLANDS : Biomes.BADLANDS;
        }
        return humidityIndex < 3 ? Biomes.BADLANDS : Biomes.WOODED_BADLANDS;
    }

    protected ResourceKey<Biome> pickPlateauBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (weirdness.max() < 0L) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, this.PLATEAU_BIOMES_BOP[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES[temperatureIndex][humidityIndex]);
        }
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.PLATEAU_BIOMES_VARIANT_BOP[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES_BOP[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES_VARIANT[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES[temperatureIndex][humidityIndex]);
    }

    protected ResourceKey<Biome> pickPeakBiome(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        if (temperatureIndex <= 2) {
            return weirdness.max() < 0L ? Biomes.JAGGED_PEAKS : Biomes.FROZEN_PEAKS;
        }
        return temperatureIndex == 3 ? Biomes.STONY_PEAKS : this.pickBadlandsBiome(humidityIndex, weirdness);
    }

    protected ResourceKey<Biome> pickPeakBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.PEAK_BIOMES_BOP[temperatureIndex][humidityIndex], this.pickPeakBiome(temperatureIndex, humidityIndex, weirdness));
    }

    protected ResourceKey<Biome> pickSlopeBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.SLOPE_BIOMES_BOP[temperatureIndex][humidityIndex], this.pickPlateauBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness));
    }

    protected ResourceKey<Biome> pickExtremeHillsBiomeVanilla(int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        ResourceKey<Biome> resourcekey = this.EXTREME_HILLS_BIOMES[temperatureIndex][humidityIndex];
        return resourcekey == null ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : resourcekey;
    }

    protected ResourceKey<Biome> pickExtremeHillsBiomeBOP(Registry<Biome> biomeRegistry, int temperatureIndex, int humidityIndex, Climate.Parameter weirdness) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.EXTREME_HILLS_BIOMES_BOP[temperatureIndex][humidityIndex], this.pickExtremeHillsBiomeVanilla(temperatureIndex, humidityIndex, weirdness));
    }

    protected void addSurfaceBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)weirdness, (float)offset), biome));
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)1.0f), (Climate.Parameter)weirdness, (float)offset), biome));
    }

    protected void addUndergroundBiome(Registry<Biome> biomeRegistry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome, ResourceKey<Biome> fallbackBiome) {
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.span((float)0.2f, (float)0.9f), (Climate.Parameter)weirdness, (float)offset), BiomeUtil.biomeOrFallback(biomeRegistry, biome, fallbackBiome)));
    }

    private void addBottomBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter erosion, Climate.Parameter weirdness, float offset, ResourceKey<Biome> biome) {
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)Climate.parameters((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)erosion, (Climate.Parameter)Climate.Parameter.point((float)1.1f), (Climate.Parameter)weirdness, (float)offset), biome));
    }
}

