/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOnePlayerInteractable;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.screens.SpeakerBlockScreen;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpeakerBlock;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySpeakerMessagePacket;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SpeakerBlockTile
extends BlockEntity
implements Nameable,
IOnePlayerInteractable,
IScreenProvider {
    private Component message = Component.empty();
    private Component filteredMessage = Component.empty();
    private Mode mode = Mode.CHAT;
    private double volume = CommonConfigs.Redstone.SPEAKER_RANGE.get().intValue();
    private Component customName;
    @Nullable
    private UUID playerWhoMayEdit = null;
    public Object ccHack = null;

    public SpeakerBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.SPEAKER_BLOCK_TILE.get(), pos, state);
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component getCustomName() {
        return this.customName;
    }

    public Component getDefaultName() {
        return Component.translatable((String)"gui.supplementaries.speaker_block");
    }

    public double getVolume() {
        return this.volume;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Component getMessage(boolean filtered) {
        return filtered ? this.filteredMessage : this.message;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setMessage(Component message) {
        this.setMessage(message, message);
    }

    public void setMessage(Component message, Component filteredMessage) {
        this.message = message;
        this.filteredMessage = filteredMessage;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
        this.message = Component.Serializer.fromJson((String)tag.getString("Message"), (HolderLookup.Provider)registries);
        this.filteredMessage = tag.contains("FilteredMessage") ? Component.Serializer.fromJson((String)tag.getString("FilteredMessage"), (HolderLookup.Provider)registries) : this.message;
        Mode m = Mode.values()[tag.getInt("Mode")];
        if (m == Mode.NARRATOR && !CommonConfigs.Redstone.SPEAKER_NARRATOR.get().booleanValue()) {
            m = Mode.CHAT;
        }
        this.mode = m;
        this.volume = tag.getDouble("Volume");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)registries));
        }
        tag.putString("Message", Component.Serializer.toJson((Component)this.message, (HolderLookup.Provider)registries));
        if (this.message != this.filteredMessage) {
            tag.putString("FilteredMessage", Component.Serializer.toJson((Component)this.filteredMessage, (HolderLookup.Provider)registries));
        }
        tag.putInt("Mode", this.mode.ordinal());
        tag.putDouble("Volume", this.volume);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        Component name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
        if (name != null) {
            this.customName = name;
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
    }

    public void sendMessage() {
        BlockState state = this.getBlockState();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!this.message.equals((Object)"")) {
                BlockPos pos = this.getBlockPos();
                this.level.blockEvent(pos, this.getBlockState().getBlock(), 0, 0);
                Style style = (Boolean)state.getValue((Property)SpeakerBlock.ANTIQUE) == false ? Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.ITALIC}) : Style.EMPTY.withFont(ModTextures.ANTIQUABLE_FONT).applyFormats(new ChatFormatting[]{ChatFormatting.ITALIC});
                String name = this.getName().getString();
                Object s = "";
                if (name.isEmpty()) {
                    s = "Speaker Block: ";
                } else if (!name.equals("\"\"") && !name.equals("\"")) {
                    s = (String)s + name + ": ";
                }
                MutableComponent component = Component.literal((String)((String)s + this.message.getString())).withStyle(style);
                MutableComponent filtered = Component.literal((String)((String)s + this.filteredMessage.getString())).withStyle(style);
                NetworkHelper.sendToAllClientPlayersInRange((ServerLevel)server, (BlockPos)pos, (double)this.volume, (CustomPacketPayload)new ClientBoundPlaySpeakerMessagePacket((Component)component, (Component)filtered, this.mode));
            }
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public boolean tryAcceptingClientText(ServerPlayer player, FilteredText filteredText) {
        if (this.isEditingPlayer(this.worldPosition, (Player)player)) {
            this.acceptClientMessages((Player)player, filteredText);
            this.setPlayerWhoMayEdit(null);
            return true;
        }
        Supplementaries.LOGGER.warn("Player {} just tried to change non-editable speaker block", (Object)player.getName().getString());
        return false;
    }

    private void acceptClientMessages(Player player, FilteredText filteredText) {
        Style style = this.getMessage(player.isTextFilteringEnabled()).getStyle();
        if (player.isTextFilteringEnabled()) {
            this.setMessage((Component)Component.literal((String)filteredText.filteredOrEmpty()).setStyle(style));
        } else {
            this.setMessage((Component)Component.literal((String)filteredText.raw()).setStyle(style), (Component)Component.literal((String)filteredText.filteredOrEmpty()).setStyle(style));
        }
    }

    public void setPlayerWhoMayEdit(UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public void openScreen(Level level, Player player, Direction direction) {
        SpeakerBlockScreen.open(this);
    }

    public static enum Mode {
        CHAT,
        STATUS_MESSAGE,
        TITLE,
        NARRATOR;

    }
}

