/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlingshotRendererHelper {
    private static BlockPos lookPos = null;

    public static void grabNewLookPos(Player player) {
        Vec3 range;
        Vec3 start;
        float blockRange = 40.0f;
        Level level = player.level();
        BlockHitResult raytrace = level.clip(new ClipContext(start = player.position().add(0.0, (double)player.getEyeHeight(), 0.0), start.add(range = player.getLookAngle().scale((double)blockRange)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (raytrace.getType() == HitResult.Type.BLOCK && start.distanceToSqr(raytrace.getLocation()) > Mth.square((double)player.getAttributeBaseValue(Attributes.BLOCK_INTERACTION_RANGE))) {
            lookPos = raytrace.getBlockPos().relative(raytrace.getDirection(), 0);
        }
    }

    public static void renderBlockOutline(PoseStack matrixStack, Camera camera, Minecraft mc) {
        if (lookPos != null) {
            LocalPlayer player = mc.player;
            Level level = player.level();
            level.getProfiler().popPush("outline");
            BlockPos pos = lookPos;
            BlockState blockstate = level.getBlockState(pos);
            if (!blockstate.isAir() && level.getWorldBorder().isWithinBounds(pos)) {
                VertexConsumer builder = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines());
                Vec3 vector3d = camera.getPosition();
                double pX = vector3d.x();
                double pY = vector3d.y();
                double pZ = vector3d.z();
                int color = ClientConfigs.Items.SLINGSHOT_OUTLINE_COLOR.get();
                float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
                float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
                float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
                float a = (float)FastColor.ARGB32.alpha((int)color) / 255.0f;
                SlingshotRendererHelper.renderVoxelShape(matrixStack, builder, blockstate.getShape((BlockGetter)level, pos, CollisionContext.of((Entity)camera.getEntity())), (double)pos.getX() - pX, (double)pos.getY() - pY, (double)pos.getZ() - pZ, r, g, b, a);
            }
        }
        lookPos = null;
    }

    private static void renderVoxelShape(PoseStack pMatrixStack, VertexConsumer pBuffer, VoxelShape pShape, double pX, double pY, double pZ, float pRed, float pGreen, float pBlue, float pAlpha) {
        PoseStack.Pose last = pMatrixStack.last();
        pShape.forAllEdges((e1, e2, e3, e4, e5, e6) -> {
            float f = (float)(e4 - e1);
            float f1 = (float)(e5 - e2);
            float f2 = (float)(e6 - e3);
            float f3 = Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
            pBuffer.addVertex(last.pose(), (float)(e1 + pX), (float)(e2 + pY), (float)(e3 + pZ)).setColor(pRed, pGreen, pBlue, pAlpha).setNormal(last, f /= f3, f1 /= f3, f2 /= f3);
            pBuffer.addVertex(last.pose(), (float)(e4 + pX), (float)(e5 + pY), (float)(e6 + pZ)).setColor(pRed, pGreen, pBlue, pAlpha).setNormal(last, f, f1, f2);
        });
    }
}

