/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import net.mehvahdjukaar.supplementaries.client.particles.BubbleBlockParticle;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class SudsParticle
extends BubbleBlockParticle {
    protected static final int POP_FRAMES = 4;
    private final double additionalSize;

    SudsParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet pSprites) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pSprites);
        this.friction = 0.96f;
        this.gravity = -0.05f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.additionalSize = SudsParticle.rand(0.08, 0.9) - 0.08;
        this.lifetime = (int)SudsParticle.rand(32.0, 0.85);
        this.hasPhysics = true;
        this.setSize(0.01f, 0.01f);
    }

    @Override
    public float getQuadSize(float age) {
        float t = (float)this.age + age;
        double a = 0.15;
        float inc = (float)(this.additionalSize * (1.0 + 1.0 / ((double)(-t) * a - 1.0)));
        return this.quadSize + inc;
    }

    @Override
    public void tick() {
        if (this.age > 6) {
            this.hasPhysics = true;
        }
        super.tick();
        this.setColorForAge();
    }

    public void move(double x, double y, double z) {
        Vec3 wantedPos;
        Vec3 myPos;
        super.move(x, y, z);
        if (this.hasPhysics && this.age < this.lifetime - 4 && (myPos = new Vec3(this.x, this.y, this.z)).distanceToSqr(wantedPos = new Vec3(this.xo + x, this.yo + y, this.zo + z)) > 1.0E-6) {
            this.age = this.lifetime - 4;
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
        }
    }

    @Override
    public void updateSprite() {
        int i = this.lifetime - this.age;
        int s = 2;
        if (i < 3 * s) {
            int j = Math.max(i, 0) / s;
            int popTime = 30;
            this.setSprite(this.sprites.get((int)((float)popTime * (3.0f - (float)j) / 3.0f), popTime));
            if (this.gravity != 0.0f) {
                this.level.playLocalSound(this.x, this.y, this.z, ModSounds.BUBBLE_POP.get(), SoundSource.BLOCKS, 0.15f, 2.0f - this.quadSize * 0.2f, false);
                this.gravity = 0.0f;
                this.yd = 0.0;
            }
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Factory(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            RandomSource r = pLevel.random;
            return new SudsParticle(pLevel, pX, pY, pZ, pXSpeed + (0.5 - (double)r.nextFloat()) * 0.04, pYSpeed + (0.5 - (double)r.nextFloat()) * 0.04, pZSpeed + (0.5 - (double)r.nextFloat()) * 0.04, this.sprite);
        }
    }
}

