/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.stock_ticker;

import com.krei.cmpackagecouriers.stock_ticker.LogisticallyLinkedItem;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticsManager;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;
import ru.zznty.create_factory_abstractions.generic.support.GenericLogisticsManager;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;

public abstract class StockCheckingItem
extends LogisticallyLinkedItem {
    protected static UUID Freq;

    @Override
    public boolean isFoil(ItemStack pStack) {
        return StockCheckingItem.isTuned(pStack);
    }

    public StockCheckingItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public static GenericInventorySummary getRecentSummary(ItemStack stack) {
        Freq = StockCheckingItem.networkFromStack(stack);
        return GenericInventorySummary.of((InventorySummary)LogisticsManager.getSummaryOfNetwork((UUID)Freq, (boolean)false));
    }

    public static GenericInventorySummary getAccurateSummary(ItemStack stack) {
        Freq = StockCheckingItem.networkFromStack(stack);
        if (Freq == null) {
            return GenericInventorySummary.empty();
        }
        return GenericInventorySummary.of((InventorySummary)LogisticsManager.getSummaryOfNetwork((UUID)Freq, (boolean)true));
    }

    public static boolean broadcastPackageRequest(ItemStack stack, LogisticallyLinkedBehaviour.RequestType type, PackageOrderWithCrafts order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        Freq = StockCheckingItem.networkFromStack(stack);
        return LogisticsManager.broadcastPackageRequest((UUID)Freq, (LogisticallyLinkedBehaviour.RequestType)type, (PackageOrderWithCrafts)order, (IdentifiedInventory)ignoredHandler, (String)address);
    }

    public boolean broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType type, GenericOrder order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        return GenericLogisticsManager.broadcastPackageRequest((UUID)Freq, (LogisticallyLinkedBehaviour.RequestType)type, (GenericOrder)order, (IdentifiedInventory)ignoredHandler, (String)address);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!StockCheckingItem.isTuned(stack)) {
            player.displayClientMessage((Component)Component.translatable((String)"item.cmpackagecouriers.portable_stock_ticker.not_linked"), true);
            return super.use(level, player, hand);
        }
        return super.use(level, player, hand);
    }

    public UUID getFrequency() {
        return Freq;
    }
}

