/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.stock_ticker;

import com.krei.cmpackagecouriers.stock_ticker.GenericStackListPacket;
import com.krei.cmpackagecouriers.stock_ticker.PortableStockTicker;
import com.krei.cmpackagecouriers.stock_ticker.PortableStockTickerReg;
import com.krei.cmpackagecouriers.stock_ticker.StockCheckingItem;
import java.util.UUID;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class RequestStockUpdate
implements ServerboundPacketPayload {
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestStockUpdate> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, packet -> packet.networkId, RequestStockUpdate::new);
    private final UUID networkId;

    public RequestStockUpdate(UUID networkId) {
        if (networkId == null) {
            this.networkId = UUID.randomUUID();
            return;
        }
        this.networkId = networkId;
    }

    public void handle(ServerPlayer player) {
        if (player != null) {
            ItemStack stack = PortableStockTicker.find(player.getInventory());
            if (stack == null || stack.isEmpty()) {
                return;
            }
            GenericStackListPacket responsePacket = new GenericStackListPacket(StockCheckingItem.getAccurateSummary(stack).get());
            CatnipServices.NETWORK.sendToClient(player, (CustomPacketPayload)responsePacket);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return PortableStockTickerReg.PortableStockTickerPackets.REQUEST_STOCK_UPDATE;
    }
}

