/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.stock_ticker;

import com.krei.cmpackagecouriers.stock_ticker.PortableStockTicker;
import com.krei.cmpackagecouriers.stock_ticker.PortableStockTickerReg;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HiddenCategoriesPacket
implements ServerboundPacketPayload {
    public static final StreamCodec<RegistryFriendlyByteBuf, HiddenCategoriesPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)CatnipStreamCodecBuilders.list((StreamCodec)ByteBufCodecs.INT), packet -> packet.indices, HiddenCategoriesPacket::new);
    private final List<Integer> indices;

    public HiddenCategoriesPacket(List<Integer> indices) {
        this.indices = indices;
    }

    public void handle(ServerPlayer player) {
        ItemStack stack = PortableStockTicker.find(player.getInventory());
        if (stack == null) {
            return;
        }
        Item item = stack.getItem();
        if (item instanceof PortableStockTicker) {
            PortableStockTicker pst = (PortableStockTicker)item;
            HashMap<UUID, List<Integer>> hiddenCategories = new HashMap<UUID, List<Integer>>();
            hiddenCategories.put(player.getUUID(), this.indices);
            pst.hiddenCategoriesByPlayer = hiddenCategories;
            pst.saveHiddenCategoriesByPlayerToStack(stack, hiddenCategories);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return PortableStockTickerReg.PortableStockTickerPackets.HIDDEN_CATEGORIES;
    }
}

