/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.plane;

import com.krei.cmpackagecouriers.PackageCouriers;
import com.krei.cmpackagecouriers.compat.cmpackagepipebomb.PackagePipebombCompat;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.depot.DepotBlock;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CardboardPlaneEntity
extends Projectile {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(CardboardPlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    @Nullable
    private UUID targetEntityUUID = null;
    @Nullable
    protected Entity targetEntityCached = null;
    @Nullable
    protected Vec3 targetPos = null;
    @Nullable
    protected ResourceKey<Level> targetPosLevel = null;
    protected double speed = 0.8;
    public float newDeltaYaw = 0.0f;
    public float oldDeltaYaw = 0.0f;
    public boolean unpack = false;

    public CardboardPlaneEntity(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public CardboardPlaneEntity(Level level) {
        super((EntityType)PackageCouriers.CARDBOARD_PLANE_ENTITY.get(), level);
    }

    public static CardboardPlaneEntity createEmpty(EntityType<? extends CardboardPlaneEntity> entityType, Level level) {
        return new CardboardPlaneEntity(entityType, level);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick() {
        Level tpLevel;
        ServerLevel serverLevel;
        Level level;
        Vec3 vecTo;
        Level level2;
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.updateRotation();
        this.setPos(d0, d1, d2);
        this.oldDeltaYaw = this.newDeltaYaw;
        this.newDeltaYaw = this.yRotO - this.getYRot();
        if (this.level().isClientSide()) {
            if (this.tickCount % 3 != 0) return;
            Vec3 lookAngle = this.getLookAngle().scale(0.5);
            this.level().addParticle((ParticleOptions)ParticleTypes.FIREWORK, this.getX() + lookAngle.x(), this.getY() + lookAngle.y(), this.getZ() + lookAngle.z(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
            return;
        }
        if (this.targetEntityUUID != null && this.targetEntityCached == null && (level2 = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel2 = (ServerLevel)level2;
            this.targetEntityCached = serverLevel2.getEntity(this.targetEntityUUID);
            PackageCouriers.LOGGER.debug("cachedEntity");
        }
        if (this.targetEntityCached != null) {
            this.targetPos = this.targetEntityCached instanceof LivingEntity ? this.targetEntityCached.getEyePosition() : this.targetEntityCached.position();
            this.targetPosLevel = this.targetEntityCached.level().dimension();
        }
        if (this.targetPos == null) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.targetPos.closerThan((Position)this.position(), 40.0) && (level2 = this.targetEntityCached) instanceof Player) {
            Player player = (Player)level2;
            player.displayClientMessage((Component)Component.translatable((String)"cmpackagecouriers.message.inbound"), true);
        }
        if (this.targetPos.closerThan((Position)this.position(), 1.5)) {
            this.onReachedTarget();
            this.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        Vec3 vecFrom = this.getDeltaMovement().normalize();
        if (this.targetPosLevel != this.level().dimension()) {
            vecTo = this.getDeltaMovement().normalize();
        } else if (!this.targetPos.closerThan((Position)this.position(), 80.0)) {
            vecTo = this.targetPos.subtract(this.position());
            vecTo = new Vec3(vecTo.x(), vecTo.y() + vecTo.length() / 2.0, vecTo.z()).normalize();
        } else {
            vecTo = this.targetPos.subtract(this.position()).normalize();
        }
        float augmentedDistance = (float)this.targetPos.subtract(this.position()).length() + (float)Math.max(0, 80 - this.tickCount);
        float clampedDistance = Mth.clamp((float)augmentedDistance, (float)5.0f, (float)60.0f);
        float curveAmount = Mth.lerp((float)((clampedDistance - 5.0f) / 55.0f), (float)0.4f, (float)0.06f);
        this.setDeltaMovement(vecFrom.lerp(vecTo, (double)curveAmount).normalize().scale(this.speed));
        Vec3 posAhead = this.position().add(this.getDeltaMovement().normalize().scale(20.0));
        if ((!CardboardPlaneEntity.isChunkTicking(this.level(), posAhead) || this.tickCount > 120) && (level = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if (this.targetPosLevel != null) {
                tpLevel = serverLevel.getServer().getLevel(this.targetPosLevel);
                if (!this.targetPos.closerThan((Position)this.position(), 80.0) || this.targetPosLevel != this.level().dimension()) {
                    Vec3 tpVec;
                    Vec3 dirVec = this.position().subtract(this.targetPos);
                    dirVec = new Vec3(dirVec.x(), 0.0, dirVec.z()).normalize();
                    if (CardboardPlaneEntity.isChunkTicking(tpLevel, this.targetPos.add((dirVec = new Vec3(dirVec.x(), 0.5, dirVec.z()).normalize()).scale(70.0)))) {
                        tpVec = this.targetPos.add(dirVec.scale(70.0));
                    } else if (CardboardPlaneEntity.isChunkTicking(tpLevel, this.targetPos.add(dirVec.scale(50.0)))) {
                        tpVec = this.targetPos.add(dirVec.scale(50.0));
                    } else if (CardboardPlaneEntity.isChunkTicking(tpLevel, this.targetPos.add(dirVec.scale(30.0)))) {
                        tpVec = this.targetPos.add(dirVec.scale(30.0));
                    } else if (CardboardPlaneEntity.isChunkTicking(tpLevel, this.targetPos.add(dirVec.scale(10.0)))) {
                        tpVec = this.targetPos.add(dirVec.scale(10.0));
                    } else {
                        if (!CardboardPlaneEntity.isChunkTicking(tpLevel, this.targetPos)) {
                            this.remove(Entity.RemovalReason.DISCARDED);
                            return;
                        }
                        tpVec = this.targetPos;
                    }
                    if (this.targetPosLevel != this.level().dimension()) {
                        this.teleportTo((ServerLevel)tpLevel, tpVec.x(), tpVec.y(), tpVec.z(), Collections.emptySet(), this.getYRot(), this.getXRot());
                    } else {
                        this.teleportTo(tpVec.x(), tpVec.y(), tpVec.z());
                    }
                    this.setDeltaMovement(this.targetPos.subtract(this.position()).normalize().scale(this.speed));
                }
            }
        }
        if (this.tickCount <= 400) return;
        tpLevel = this.level();
        if (tpLevel instanceof ServerLevel) {
            serverLevel = (ServerLevel)tpLevel;
            if (this.targetPosLevel != null) {
                tpLevel = serverLevel.getServer().getLevel(this.targetPosLevel);
                this.teleportTo((ServerLevel)tpLevel, this.targetPos.x(), this.targetPos.y(), this.targetPos.z(), Collections.emptySet(), this.getYRot(), this.getXRot());
                PackageCouriers.LOGGER.debug("Timeout: " + String.valueOf(this.targetPos));
                return;
            }
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    protected void onReachedTarget() {
        Entity entity;
        if (this.targetEntityCached != null && (entity = this.targetEntityCached) instanceof Player) {
            Player player = (Player)entity;
            if (!this.level().isClientSide()) {
                if (this.unpack) {
                    ItemStackHandler stacks = PackageItem.getContents((ItemStack)this.getPackage());
                    for (int slot = 0; slot < stacks.getSlots(); ++slot) {
                        ItemStack stack = stacks.getStackInSlot(slot);
                        PackageCouriers.LOGGER.debug(String.valueOf(stack));
                        if (ModList.get().isLoaded("cmpackagepipebomb") && PackagePipebombCompat.isRigged(stack)) {
                            PackagePipebombCompat.spawnRigged(stack, this.level(), this.getX(), this.getY(), this.getZ());
                            continue;
                        }
                        player.getInventory().placeItemBackInInventory(stack);
                    }
                } else {
                    player.getInventory().placeItemBackInInventory(this.getPackage());
                }
            }
        } else if (this.targetPos != null && !this.level().isClientSide()) {
            DepotBlockEntity depot;
            BlockEntity blockEntity;
            BlockPos blockPos = new BlockPos((int)Math.floor(this.targetPos.x()), (int)Math.floor(this.targetPos.y()), (int)Math.floor(this.targetPos.z()));
            if (this.level().getBlockState(blockPos).getBlock() instanceof DepotBlock && (blockEntity = this.level().getBlockEntity(blockPos)) instanceof DepotBlockEntity && (depot = (DepotBlockEntity)blockEntity).getHeldItem().is(Items.AIR)) {
                depot.setHeldItem(this.getPackage());
                depot.notifyUpdate();
            } else {
                this.level().addFreshEntity((Entity)PackageEntity.fromItemStack((Level)this.level(), (Vec3)this.position(), (ItemStack)this.getPackage()));
            }
        }
        ItemParticleOption particleOption = new ItemParticleOption(ParticleTypes.ITEM, AllItems.CARDBOARD.asStack());
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)particleOption, this.position().x(), this.position().y(), this.position().z(), 20, 0.3, 0.3, 0.3, 0.1);
        }
        this.level().playSound(null, this.position().x(), this.position().y(), this.position().z(), (SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), SoundSource.NEUTRAL, 1.0f, 0.75f);
    }

    public void setTarget(@Nullable Entity targetEntity) {
        if (targetEntity != null) {
            this.targetEntityUUID = targetEntity.getUUID();
            this.targetEntityCached = targetEntity;
        }
    }

    public void setTarget(BlockPos targetBlock, Level level) {
        this.targetPos = Vec3.atCenterOf((Vec3i)targetBlock);
        this.targetPosLevel = level.dimension();
        this.targetEntityCached = null;
        this.targetEntityUUID = null;
    }

    public void shootFromRotation(float x, float y, float z, float velocity, float inaccuracy) {
        float f = -Mth.sin((float)(y * ((float)Math.PI / 180))) * Mth.cos((float)(x * ((float)Math.PI / 180)));
        float f1 = -Mth.sin((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(y * ((float)Math.PI / 180))) * Mth.cos((float)(x * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM, (Object)ItemStack.EMPTY);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        ItemStack box = ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)compoundTag.getCompound("Box"));
        this.setPackage(box);
        if (compoundTag.hasUUID("TargetEntity")) {
            this.targetEntityUUID = compoundTag.getUUID("TargetEntity");
        } else if (compoundTag.contains("TargetPosX")) {
            double x = compoundTag.getDouble("TargetPosX");
            double y = compoundTag.getDouble("TargetPosY");
            double z = compoundTag.getDouble("TargetPosZ");
            this.targetPos = new Vec3(x, y, z);
        } else if (compoundTag.contains("Unpack")) {
            this.unpack = compoundTag.getBoolean("Unpack");
        }
        this.refreshDimensions();
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        ItemStack box = this.getPackage();
        compoundTag.put("Box", box.saveOptional((HolderLookup.Provider)this.level().registryAccess()));
        compoundTag.putBoolean("Unpack", this.unpack);
        if (this.targetEntityUUID != null) {
            compoundTag.putUUID("TargetEntity", this.targetEntityUUID);
        } else if (this.targetPos != null) {
            compoundTag.putDouble("TargetPosX", this.targetPos.x());
            compoundTag.putDouble("TargetPosY", this.targetPos.y());
            compoundTag.putDouble("TargetPosZ", this.targetPos.z());
        }
    }

    public ItemStack getPackage() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM);
    }

    public void setPackage(ItemStack stack) {
        if (stack.getItem() instanceof PackageItem) {
            this.getEntityData().set(DATA_ITEM, (Object)stack);
        }
    }

    public boolean isUnpack() {
        return this.unpack;
    }

    public void setUnpack(boolean unpack) {
        this.unpack = unpack;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public static boolean isChunkTicking(Level level, Vec3 pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = new BlockPos((int)pos.x(), (int)pos.y(), (int)pos.z());
            return serverLevel.getChunkSource().chunkMap.getDistanceManager().inEntityTickingRange(ChunkPos.asLong((BlockPos)blockPos));
        }
        return false;
    }

    public static void init() {
    }
}

