/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.events;

import com.krei.cmpackagecouriers.ServerConfig;
import com.simibubi.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="cmpackagecouriers")
public class StockTickerIntegration {
    private static void rewriteAddressIfNeeded(Player player, ItemStack heldItem) {
        String currentAddress;
        if (heldItem.getItem() instanceof ShoppingListItem && (currentAddress = ShoppingListItem.getAddress((ItemStack)heldItem)).toLowerCase().contains("@player")) {
            String playerIdentifier = player.getDisplayName().getString();
            String newAddress = currentAddress.replaceAll("(?i)@player", "@" + playerIdentifier);
            ShoppingListItem.saveList((ItemStack)heldItem, (ShoppingListItem.ShoppingList)ShoppingListItem.getList((ItemStack)heldItem), (String)newAddress);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!ServerConfig.shopAddressReplacement) {
            return;
        }
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity target = event.getTarget();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.getItemInHand(hand);
        if (player == null || target == null || player.isSpectator() || hand != InteractionHand.MAIN_HAND) {
            return;
        }
        BlockPos stockTickerPos = StockTickerInteractionHandler.getStockTickerPosition((Entity)target);
        if (stockTickerPos != null) {
            StockTickerIntegration.rewriteAddressIfNeeded(player, heldItem);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!ServerConfig.shopAddressReplacement) {
            return;
        }
        if (event.getLevel().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.getItemInHand(hand);
        BlockPos pos = event.getPos();
        if (player == null || player.isSpectator() || hand != InteractionHand.MAIN_HAND) {
            return;
        }
        if (event.getLevel().getBlockState(pos).getBlock() instanceof BlazeBurnerBlock) {
            StockTickerIntegration.rewriteAddressIfNeeded(player, heldItem);
        }
    }
}

