/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects.quadTree.iterators;

import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadNode;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Consumer;

public class QuadNodeChildIndexIterator<T>
implements Iterator<Integer> {
    private final Queue<Integer> iteratorQueue = new ArrayDeque<Integer>();

    public QuadNodeChildIndexIterator(QuadNode<T> parentNode, boolean returnNullChildPos) {
        if (DhSectionPos.getDetailLevel(parentNode.sectionPos) > parentNode.minimumDetailLevel) {
            for (int i = 0; i < 4; ++i) {
                if (!returnNullChildPos && parentNode.getChildByIndex(i) == null) continue;
                this.iteratorQueue.add(i);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.iteratorQueue.size() != 0;
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Integer index = this.iteratorQueue.poll();
        return index;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void forEachRemaining(Consumer<? super Integer> action) {
        Iterator.super.forEachRemaining(action);
    }
}

