/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.mixin;

import com.simibubi.create.content.fluids.spout.FillingBySpout;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import plus.dragons.createenchantmentindustry.common.fluids.experience.ExperienceHelper;

@Mixin(value={FillingBySpout.class}, remap=false)
public class FillingBySpoutMixin {
    @Inject(method={"canItemBeFilled"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/fluids/transfer/GenericItemFilling;canItemBeFilled(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;)Z")}, cancellable=true)
    private static void canItemBeFilled$mending(Level level, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (ExperienceHelper.canRepairItem(stack)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getRequiredAmountForItem"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/fluids/transfer/GenericItemFilling;getRequiredAmountForItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;Lnet/neoforged/neoforge/fluids/FluidStack;)I")}, cancellable=true)
    private static void getRequiredAmountForItem$mending(Level level, ItemStack stack, FluidStack availableFluid, CallbackInfoReturnable<Integer> cir) {
        ServerLevel serverLevel;
        block6: {
            block5: {
                if (!(level instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (ExperienceHelper.canRepairItem(stack)) break block6;
            }
            return;
        }
        int availableXp = ExperienceHelper.getExperienceFromFluid(availableFluid);
        if (availableXp == 0) {
            return;
        }
        int requiredXp = ExperienceHelper.repairItem(availableXp, serverLevel, stack, true);
        int requiredFluid = ExperienceHelper.getFluidFromExperience(availableFluid, requiredXp);
        if (requiredFluid > 0) {
            cir.setReturnValue((Object)requiredFluid);
        }
    }

    @Inject(method={"fillItem"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/fluids/transfer/GenericItemFilling;fillItem(Lnet/minecraft/world/level/Level;ILnet/minecraft/world/item/ItemStack;Lnet/neoforged/neoforge/fluids/FluidStack;)Lnet/minecraft/world/item/ItemStack;")}, cancellable=true)
    private static void fillItem$mending(Level level, int requiredAmount, ItemStack stack, FluidStack availableFluid, CallbackInfoReturnable<ItemStack> cir) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (ExperienceHelper.canRepairItem(stack)) {
                int availableXp = ExperienceHelper.getExperienceFromFluid(availableFluid);
                if (availableXp == 0) {
                    return;
                }
                ItemStack result = stack.copy();
                stack.shrink(1);
                ExperienceHelper.repairItem(availableXp, serverLevel, result, false);
                availableFluid.shrink(availableXp);
                cir.setReturnValue((Object)result);
            }
        }
    }
}

