/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.mixin;

import bre2el.fpsreducer.FpsReducer;
import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.handler.WakeupEventHandler;
import bre2el.fpsreducer.handler.glfw.InputEventHandler;
import bre2el.fpsreducer.util.GlfwUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderSystem.class})
public class RenderSystemMixin {
    @Shadow
    private static double lastDrawTime;

    @Inject(method={"limitDisplayFPS"}, at={@At(value="HEAD")}, cancellable=true)
    private static void handleWaitEventsTimeout(int fps, CallbackInfo ci) {
        if (!FpsReducer.initComplete) {
            return;
        }
        double wakeupTime = lastDrawTime + 1.0 / (double)fps;
        double curTime = GLFW.glfwGetTime();
        while (curTime < wakeupTime) {
            if (WakeupEventHandler.INSTANCE.cancelableWaitEvents && InputEventHandler.INSTANCE.isInputEventInIdle()) {
                if (GlfwUtils.isWindowFocused() || !Config.CURRENT.reducingInBackground) {
                    if (RenderSystemMixin.isClickKeyBindPressed() && fps < 20) {
                        double wait = fps < 5 ? 0.2 : 1.0 / (double)fps;
                        GLFW.glfwWaitEventsTimeout((double)wait);
                    }
                    curTime = GLFW.glfwGetTime();
                    WakeupEventHandler.INSTANCE.cancelableWaitEvents = false;
                    WakeupEventHandler.INSTANCE.forceRecoverFPS("Interrupted WaitEventsTimeout.");
                    break;
                }
                InputEventHandler.INSTANCE.clearInputEventInIdle();
            }
            GLFW.glfwWaitEventsTimeout((double)(wakeupTime - curTime));
            curTime = GLFW.glfwGetTime();
        }
        lastDrawTime = curTime;
        ci.cancel();
    }

    private static boolean isClickKeyBindPressed() {
        boolean clickEvent = false;
        try {
            clickEvent = Minecraft.getInstance().options.keyAttack.isDown() || Minecraft.getInstance().options.keyUse.isDown() || Minecraft.getInstance().options.keyPickItem.isDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clickEvent;
    }
}

