/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.config;

import bre2el.fpsreducer.config.CommonConfig;
import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.util.Logger;
import java.io.File;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GlobalConfig
extends CommonConfig {
    private static final ModConfigSpec globalSpec;
    private static final Global GLOBAL;
    private static final ModConfig.Type globalConfigType;

    public static void registerConfig(IEventBus modEventBus, ModContainer modContainer) {
        File configDir = FMLPaths.CONFIGDIR.get().resolve("fpsreducer").toFile();
        if (configDir.getParentFile() != null) {
            configDir.mkdirs();
            GlobalConfig.moveOldConfigFile();
        }
        modEventBus.register(GlobalConfig.class);
        modContainer.registerConfig(globalConfigType, (IConfigSpec)globalSpec, "fpsreducer" + File.separator + GlobalConfig.getGlobalConfigFileName());
        GlobalConfig.GLOBAL.configRegistered = true;
    }

    private static String getGlobalConfigFileName() {
        return String.format("%s-%s.toml", "fpsreducer", globalConfigType.extension());
    }

    private static void moveOldConfigFile() {
        File oldConfigFile = FMLPaths.CONFIGDIR.get().resolve(GlobalConfig.getGlobalConfigFileName()).toFile();
        if (oldConfigFile.exists()) {
            File destFile = FMLPaths.CONFIGDIR.get().resolve("fpsreducer" + File.separator + GlobalConfig.getGlobalConfigFileName()).toFile();
            if (!destFile.exists()) {
                oldConfigFile.renameTo(destFile);
            } else {
                File backupFile = FMLPaths.CONFIGDIR.get().resolve("fpsreducer" + File.separator + "oldConfig.bak").toFile();
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                oldConfigFile.renameTo(backupFile);
            }
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getType() == globalConfigType) {
            ModConfig modConfig = configEvent.getConfig();
            if (modConfig.getSpec() == globalSpec) {
                GLOBAL.readFromConfigData();
                Logger.debug("Global config file loaded.");
                GlobalConfig.GLOBAL.configLoaded = true;
            }
            Config.initCurrentConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        if (GlobalConfig.GLOBAL.disableOnFileChangeEvent) {
            return;
        }
        if (configEvent.getConfig().getType() == globalConfigType) {
            ModConfig modConfig = configEvent.getConfig();
            if (GlobalConfig.GLOBAL.configLoaded && modConfig.getSpec() == globalSpec) {
                Global global = GLOBAL;
                synchronized (global) {
                    GLOBAL.readFromConfigData();
                    Logger.debug("Global config file got changed on the file system.");
                }
            }
        }
    }

    static {
        globalConfigType = ModConfig.Type.CLIENT;
        Pair globalSpecPair = new ModConfigSpec.Builder().configure(Global::new);
        globalSpec = (ModConfigSpec)globalSpecPair.getRight();
        Config.GLOBAL = GLOBAL = (Global)globalSpecPair.getLeft();
    }

    public static class Global
    extends CommonConfig.Common {
        public int hudColor;
        public String hudPreText = "FPS: ";
        public int hudReductionColor;
        public String hudReductionPreText = "ECO: ";
        public int hudGuiModeColor;
        public String hudGuiModePreText = "FPS: ";
        public int hudNoActModeColor;
        private final int COLOR_IDLE = 61440;
        private final int COLOR_NORMAL = 0xF0F0F0;
        private final int COLOR_GUI = 11988223;
        private final int COLOR_NOACT = 13565908;
        public boolean allowPlayerConfig;
        public int cpuUsageType;
        public static final int CPU_USAGE_TYPE_ONE_CPU_BASIS = 0;
        public static final int CPU_USAGE_TYPE_ALL_CPU_BASIS = 1;
        public int cpuUsageThread;
        public static final int CPU_USAGE_THREAD_CLIENT_ONLY = 0;
        public static final int CPU_USAGE_THREAD_ALL = 1;
        public boolean allowOneFps;
        public boolean noWaitRecovery = true;
        public boolean debugLog;
        private final ModConfigSpec.ConfigValue<String> hudColorVal;
        private final ModConfigSpec.ConfigValue<String> hudReductionColorVal;
        private final ModConfigSpec.ConfigValue<String> hudGuiModeColorVal;
        private final ModConfigSpec.ConfigValue<String> hudNoActModeColorVal;
        private final ModConfigSpec.BooleanValue allowPersonalConfigVal;
        private final ModConfigSpec.IntValue cpuUsageTypeVal;
        private final ModConfigSpec.IntValue cpuUsageThreadVal;
        private final ModConfigSpec.BooleanValue allowOneFpsVal;
        private final ModConfigSpec.BooleanValue debugLogVal;

        Global(ModConfigSpec.Builder builder) {
            super(builder);
            builder.comment("Extra options").push("extra");
            this.hudColorVal = builder.comment("HUD color").translation("fpsreducer.config.hudColor").define("hudColor", (Object)CommonConfig.decToHex(0xF0F0F0));
            this.hudReductionColorVal = builder.comment("Reduced fps HUD color").translation("fpsreducer.config.hudReductionColor").define("hudReductionColor", (Object)CommonConfig.decToHex(61440));
            this.hudGuiModeColorVal = builder.comment("HUD color for FPS display in GUI screen(inventory and menu).").translation("fpsreducer.config.hudGuiModeColor").define("hudGuiModeColor", (Object)CommonConfig.decToHex(11988223));
            this.hudNoActModeColorVal = builder.comment("HUD color for FPS display when the character is stationary.").translation("fpsreducer.config.hudNoActModeColor").define("hudNoActModeColor", (Object)CommonConfig.decToHex(13565908));
            this.allowPersonalConfigVal = builder.comment("Allow player configuration mode.").translation("fpsreducer.config.allowPlayerConfig").define("allowPlayerConfig", true);
            this.cpuUsageTypeVal = builder.comment("CPU usage type. (0:one processor basis, 1:all processors basis)").translation("fpsreducer.config.cpuUsageType").defineInRange("cpuUsageType", 0, 0, 1);
            this.cpuUsageThreadVal = builder.comment("Which thread's CPU usage should be calculated. (0:client thread only, 1:entire Minecraft process including server threads)").translation("fpsreducer.config.cpuUsageThread").defineInRange("cpuUsageThread", 0, 0, 1);
            this.allowOneFpsVal = builder.comment("Permit to set IdleFPS=1.").translation("fpsreducer.config.allowOneFps").define("allowOneFps", false);
            builder.pop();
            builder.comment("Debug options").push("debug");
            this.debugLogVal = builder.comment("Enable debug log").translation("fpsreducer.config.debugLog").define("debugLog", false);
            builder.pop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readFromConfigData() {
            Global global = this;
            synchronized (global) {
                super.readFromConfigData();
                this.hudColor = CommonConfig.hexToDec(this.hudColorVal, 0xF0F0F0);
                this.hudReductionColor = CommonConfig.hexToDec(this.hudReductionColorVal, 61440);
                this.hudGuiModeColor = CommonConfig.hexToDec(this.hudGuiModeColorVal, 11988223);
                this.hudNoActModeColor = CommonConfig.hexToDec(this.hudNoActModeColorVal, 13565908);
                this.allowPlayerConfig = (Boolean)this.allowPersonalConfigVal.get();
                this.cpuUsageType = (Integer)this.cpuUsageTypeVal.get();
                this.cpuUsageThread = (Integer)this.cpuUsageThreadVal.get();
                this.allowOneFps = (Boolean)this.allowOneFpsVal.get();
                this.debugLog = (Boolean)this.debugLogVal.get();
                this.convertOldValues();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToConfigData() {
            this.disableOnFileChangeEvent = true;
            Global global = this;
            synchronized (global) {
                super.writeToConfigData();
                this.setIfModified(this.hudColorVal, CommonConfig.decToHex(this.hudColor));
                this.setIfModified(this.hudReductionColorVal, CommonConfig.decToHex(this.hudReductionColor));
                this.setIfModified(this.hudGuiModeColorVal, CommonConfig.decToHex(this.hudGuiModeColor));
                this.setIfModified(this.hudNoActModeColorVal, CommonConfig.decToHex(this.hudNoActModeColor));
                this.setIfModified(this.allowPersonalConfigVal, this.allowPlayerConfig);
                this.setIfModified(this.cpuUsageTypeVal, this.cpuUsageType);
                this.setIfModified(this.cpuUsageThreadVal, this.cpuUsageThread);
                this.setIfModified(this.allowOneFpsVal, this.allowOneFps);
                this.setIfModified(this.debugLogVal, this.debugLog);
            }
            this.disableOnFileChangeEvent = false;
        }
    }
}

