/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.config;

import bre2el.fpsreducer.config.Profile;
import bre2el.fpsreducer.gui.HudPos;
import bre2el.fpsreducer.util.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.neoforged.neoforge.common.ModConfigSpec;

public class CommonConfig {
    protected static final String configDirName = "fpsreducer";

    protected static int hexToDec(ModConfigSpec.ConfigValue<String> hexStringVal, int defaultVal) {
        int intValue;
        try {
            intValue = Integer.parseInt((String)hexStringVal.get(), 16);
        }
        catch (NumberFormatException ne) {
            Logger.error("Parsing configuration error: " + CommonConfig.getPath(hexStringVal));
            return defaultVal;
        }
        return intValue;
    }

    protected static String decToHex(int intValue) {
        String hexString = String.format("%06x", intValue);
        return hexString;
    }

    protected static <T> String getPath(ModConfigSpec.ConfigValue<T> configValue) {
        String path = String.join((CharSequence)".", configValue.getPath());
        return path;
    }

    public static class Common
    extends Profile {
        public boolean enableFpsReducer;
        private int hudReferencePos;
        public HudPos[] hudPos = new HudPos[9];
        public double hudScale;
        public int hudBehindChatBox;
        public static final int HUD_BEFIND_CHATBOX_KEEP = 0;
        public static final int HUD_BEHIND_CHATBOX_OFF = 1;
        public static final int HUD_BEHIND_CHATBOX_DODGE = 2;
        public int hudInfo;
        public static final int HUD_INFO_DISABLED = 0;
        public static final int HUD_INFO_FPS_CPU_LONG = 1;
        public static final int HUD_INFO_FPS_CPU_SHORT = 2;
        public static final int HUD_INFO_FPS_CPU_2LINES = 3;
        public static final int HUD_INFO_FPS_ONLY = 4;
        public static final int HUD_INFO_CPU_ONLY = 5;
        public static final int HUD_INFO_SIMPLE = 6;
        private final ModConfigSpec.BooleanValue enableFpsReducerVal;
        private final ModConfigSpec.IntValue waitingTimeVal;
        private final ModConfigSpec.IntValue idleFpsVal;
        private final ModConfigSpec.IntValue guiScreenFpsVal;
        private final ModConfigSpec.IntValue noActFpsVal;
        private final ModConfigSpec.IntValue detectMovingVal;
        private final ModConfigSpec.BooleanValue ignoreHoldButtonVal;
        private final ModConfigSpec.BooleanValue reducingInGameMenuVal;
        private final ModConfigSpec.BooleanValue reducingInBackgroundVal;
        private final ModConfigSpec.BooleanValue suppressSoundVal;
        private final ModConfigSpec.IntValue suppressedVolumeVal;
        private final ModConfigSpec.BooleanValue hudEnabledVal;
        private final ModConfigSpec.IntValue hudReferencePosVal;
        private final ModConfigSpec.IntValue[] hudOffsetVal = new ModConfigSpec.IntValue[16];
        private final ModConfigSpec.IntValue[] hudAlignmentVal = new ModConfigSpec.IntValue[8];
        private final ModConfigSpec.DoubleValue hudScaleVal;
        private final ModConfigSpec.IntValue hudBehindChatBoxVal;
        private final ModConfigSpec.IntValue hudInfoVal;
        private final ModConfigSpec.IntValue profileVal;
        protected HudPos[] hudPosDefault = new HudPos[9];
        public HudPos curHudPos;
        protected final String config = "fpsreducer.config.";
        public boolean configRegistered;
        public boolean configLoaded;
        protected boolean disableOnFileChangeEvent;

        Common(ModConfigSpec.Builder builder) {
            Profile defaultProf = new Profile(1);
            for (int i = 0; i < 9; ++i) {
                this.hudPos[i] = new HudPos(i);
                this.hudPosDefault[i] = new HudPos(i);
            }
            this.initHudPosDefaultValues();
            builder.comment("General options").push("general");
            this.enableFpsReducerVal = builder.comment("Enable FPS Reducer features.").translation("fpsreducer.config.enableFpsReducer").define("enableFpsReducer", true);
            this.waitingTimeVal = builder.comment("Waiting time(sec) before reducing the FPS. (0:OFF)").translation("fpsreducer.config.waitingTime").defineInRange("waitingTime", defaultProf.waitingTime, 0, 86400);
            this.idleFpsVal = builder.comment("Max frame rate when there is no operation for the specified period of time.").translation("fpsreducer.config.idleFps").defineInRange("idleFps", defaultProf.idleFps, 1, 60);
            Options cfr_ignored_0 = Minecraft.getInstance().options;
            this.guiScreenFpsVal = builder.comment("Max frame rate during GUI screen(Inventory/Menu) is opened. (0:OFF)").translation("fpsreducer.config.guiScreenFps").defineInRange("guiScreenFps", defaultProf.guiScreenFps, 0, 260);
            Options cfr_ignored_1 = Minecraft.getInstance().options;
            this.noActFpsVal = builder.comment("Max frame rate when the character is stationary. (0:OFF)").translation("fpsreducer.config.noActFps").defineInRange("noActFps", defaultProf.noActFps, 0, 260);
            this.detectMovingVal = builder.comment("Detect movement of player position. (0:OFF, 1:Riding/Flying, 2:Always)").translation("fpsreducer.config.detectMoving").defineInRange("detectMoving", defaultProf.detectMoving, 0, 2);
            this.ignoreHoldButtonVal = builder.comment("Ignore the mouse button holding.").translation("fpsreducer.config.ignoreHoldButton").define("ignoreHoldButton", defaultProf.ignoreHoldButton);
            this.reducingInGameMenuVal = builder.comment("Reduce FPS in Game Menu.").translation("fpsreducer.config.reducingInGameMenu").define("reducingInGameMenu", defaultProf.reducingInGameMenu);
            this.reducingInBackgroundVal = builder.comment("Force reducing FPS if the window is inactive.").translation("fpsreducer.config.reducingInBackground").define("reducingInBackground", defaultProf.reducingInBackground);
            this.suppressSoundVal = builder.comment("Suppress master volume if the window is inactive.").translation("fpsreducer.config.suppressSound").define("suppressSound", defaultProf.suppressSound);
            this.suppressedVolumeVal = builder.comment("Suppression master volume ratio in inactive (0-100).").translation("fpsreducer.config.suppressedVolume").defineInRange("suppressedVolume", defaultProf.suppressedVolume, 0, 100);
            this.hudEnabledVal = builder.comment("Enable HUD.").translation("fpsreducer.config.hudEnabled").define("hudEnabled", defaultProf.hudEnabled);
            this.hudReferencePosVal = builder.comment("Reference position of HUD.").translation("fpsreducer.config.hudReferencePos").defineInRange("hudReferencePos", 3, 1, 8);
            this.hudScaleVal = builder.comment("HUD scale (default: 1.0)").translation("fpsreducer.config.hudScale").defineInRange("hudScale", 1.0, 0.1, 2.0);
            this.hudBehindChatBoxVal = builder.comment("Behavior of HUD display when a chat window opened. (0:keep to display, 1:off, 2:dodge a chat box)").translation("fpsreducer.config.hudBehindChatBox").defineInRange("hudBehindChatBox", 2, 0, 2);
            this.hudInfoVal = builder.comment("HUD information (1:FPS/CPU(long), 2:FPS/CPU(short), 3:FPS/CPU(2lines), 4:FPS only, 5:CPU only, 6:Simple)").translation("fpsreducer.config.hudInfo").defineInRange("hudInfo", 4, 0, 6);
            this.profileVal = builder.comment("Profile (0:custom, 1:modest-eco, 2:eco, 3:cooling-low, 4:cooling-high)").translation("fpsreducer.config.profile").defineInRange("profile", defaultProf.profile, 0, 4);
            builder.pop();
            builder.comment("HUD offsets from reference positions at the screen edge.").push("hud_offset");
            this.hudOffsetVal[0] = builder.translation("fpsreducer.config.topLeft_X").defineInRange("topLeft_X", this.hudPosDefault[1].offsetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[1] = builder.translation("fpsreducer.config.topLeft_Y").defineInRange("topLeft_Y", this.hudPosDefault[1].offsetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[2] = builder.translation("fpsreducer.config.topCenter_X").defineInRange("topCenter_X", this.hudPosDefault[2].offsetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[3] = builder.translation("fpsreducer.config.topCenter_Y").defineInRange("topCenter_Y", this.hudPosDefault[2].offsetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[4] = builder.translation("fpsreducer.config.topRight_X").defineInRange("topRight_X", this.hudPosDefault[3].offsetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[5] = builder.translation("fpsreducer.config.topRight_Y").defineInRange("topRight_Y", this.hudPosDefault[3].offsetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[6] = builder.translation("fpsreducer.config.centerRight_X").defineInRange("centerRight_X", this.hudPosDefault[4].offsetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[7] = builder.translation("fpsreducer.config.centerRight_Y").defineInRange("centerRight_Y", this.hudPosDefault[4].offsetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[8] = builder.translation("fpsreducer.config.bottomRight_X").defineInRange("bottomRight_X", this.hudPosDefault[5].offsetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[9] = builder.translation("fpsreducer.config.bottomRight_Y").defineInRange("bottomRight_Y", this.hudPosDefault[5].offsetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[10] = builder.translation("fpsreducer.config.bottomCenter_X").defineInRange("bottomCenter_X", this.hudPosDefault[6].offsetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[11] = builder.translation("fpsreducer.config.bottomCenter_Y").defineInRange("bottomCenter_Y", this.hudPosDefault[6].offsetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[12] = builder.translation("fpsreducer.config.bottomLeft_X").defineInRange("bottomLeft_X", this.hudPosDefault[7].offsetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[13] = builder.translation("fpsreducer.config.bottomLeft_Y").defineInRange("bottomLeft_Y", this.hudPosDefault[7].offsetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[14] = builder.translation("fpsreducer.config.centerLeft_X").defineInRange("centerLeft_X", this.hudPosDefault[8].offsetX, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hudOffsetVal[15] = builder.translation("fpsreducer.config.centerLeft_Y").defineInRange("centerLeft_Y", this.hudPosDefault[8].offsetY, Integer.MIN_VALUE, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Alignments of HUD strings.").push("hud_alignment");
            this.hudAlignmentVal[0] = builder.translation("fpsreducer.config.topLeft").defineInRange("topLeft", this.hudPosDefault[1].alignment, 0, 2);
            this.hudAlignmentVal[1] = builder.translation("fpsreducer.config.topCenter").defineInRange("topCenter", this.hudPosDefault[2].alignment, 0, 2);
            this.hudAlignmentVal[2] = builder.translation("fpsreducer.config.topRight").defineInRange("topRight", this.hudPosDefault[3].alignment, 0, 2);
            this.hudAlignmentVal[3] = builder.translation("fpsreducer.config.centerRight").defineInRange("centerRight", this.hudPosDefault[4].alignment, 0, 2);
            this.hudAlignmentVal[4] = builder.translation("fpsreducer.config.bottomRight").defineInRange("bottomRight", this.hudPosDefault[5].alignment, 0, 2);
            this.hudAlignmentVal[5] = builder.translation("fpsreducer.config.bottomCenter").defineInRange("bottomCenter", this.hudPosDefault[6].alignment, 0, 2);
            this.hudAlignmentVal[6] = builder.translation("fpsreducer.config.bottomLeft").defineInRange("bottomLeft", this.hudPosDefault[7].alignment, 0, 2);
            this.hudAlignmentVal[7] = builder.translation("fpsreducer.config.centerLeft").defineInRange("centerLeft", this.hudPosDefault[8].alignment, 0, 2);
            builder.pop();
        }

        protected void initHudPosDefaultValues() {
            this.hudPosDefault[1].setOffset(2, 2);
            this.hudPosDefault[2].setOffset(0, 2);
            this.hudPosDefault[3].setOffset(-2, 2);
            this.hudPosDefault[4].setOffset(-2, 0);
            this.hudPosDefault[5].setOffset(-2, -2);
            this.hudPosDefault[6].setOffset(0, -2);
            this.hudPosDefault[7].setOffset(2, -2);
            this.hudPosDefault[8].setOffset(2, 0);
            this.hudPosDefault[1].alignment = 0;
            this.hudPosDefault[2].alignment = 2;
            this.hudPosDefault[3].alignment = 1;
            this.hudPosDefault[4].alignment = 1;
            this.hudPosDefault[5].alignment = 1;
            this.hudPosDefault[6].alignment = 2;
            this.hudPosDefault[7].alignment = 0;
            this.hudPosDefault[8].alignment = 0;
        }

        public void convertOldValues() {
            boolean changed = false;
            if (this.hudInfo == 0) {
                this.hudEnabled = false;
                this.hudInfo = 4;
                changed = true;
            }
            if (this.correctProfile()) {
                changed = true;
            }
            if (changed) {
                this.writeToConfigData();
            }
        }

        public void readFromConfigData() {
            this.enableFpsReducer = (Boolean)this.enableFpsReducerVal.get();
            this.waitingTime = (Integer)this.waitingTimeVal.get();
            this.idleFps = (Integer)this.idleFpsVal.get();
            this.guiScreenFps = (Integer)this.guiScreenFpsVal.get();
            this.noActFps = (Integer)this.noActFpsVal.get();
            this.detectMoving = (Integer)this.detectMovingVal.get();
            this.ignoreHoldButton = (Boolean)this.ignoreHoldButtonVal.get();
            this.reducingInGameMenu = (Boolean)this.reducingInGameMenuVal.get();
            this.reducingInBackground = (Boolean)this.reducingInBackgroundVal.get();
            this.suppressSound = (Boolean)this.suppressSoundVal.get();
            this.suppressedVolume = (Integer)this.suppressedVolumeVal.get();
            this.hudEnabled = (Boolean)this.hudEnabledVal.get();
            this.setHudReferencePos((Integer)this.hudReferencePosVal.get());
            this.hudScale = (Double)this.hudScaleVal.get();
            this.hudBehindChatBox = (Integer)this.hudBehindChatBoxVal.get();
            this.hudInfo = (Integer)this.hudInfoVal.get();
            this.profile = (Integer)this.profileVal.get();
            for (int i = 0; i < 8; ++i) {
                this.hudPos[i + 1].setOffset((Integer)this.hudOffsetVal[i * 2].get(), (Integer)this.hudOffsetVal[i * 2 + 1].get());
                this.hudPos[i + 1].alignment = (Integer)this.hudAlignmentVal[i].get();
            }
        }

        public void writeToConfigData() {
            this.correctProfile();
            this.setIfModified((ModConfigSpec.ConfigValue)this.enableFpsReducerVal, this.enableFpsReducer);
            this.setIfModified((ModConfigSpec.ConfigValue)this.waitingTimeVal, this.waitingTime);
            this.setIfModified((ModConfigSpec.ConfigValue)this.idleFpsVal, this.idleFps);
            this.setIfModified((ModConfigSpec.ConfigValue)this.guiScreenFpsVal, this.guiScreenFps);
            this.setIfModified((ModConfigSpec.ConfigValue)this.noActFpsVal, this.noActFps);
            this.setIfModified((ModConfigSpec.ConfigValue)this.detectMovingVal, this.detectMoving);
            this.setIfModified((ModConfigSpec.ConfigValue)this.ignoreHoldButtonVal, this.ignoreHoldButton);
            this.setIfModified((ModConfigSpec.ConfigValue)this.reducingInGameMenuVal, this.reducingInGameMenu);
            this.setIfModified((ModConfigSpec.ConfigValue)this.reducingInBackgroundVal, this.reducingInBackground);
            this.setIfModified((ModConfigSpec.ConfigValue)this.suppressSoundVal, this.suppressSound);
            this.setIfModified((ModConfigSpec.ConfigValue)this.suppressedVolumeVal, this.suppressedVolume);
            this.setIfModified((ModConfigSpec.ConfigValue)this.hudEnabledVal, this.hudEnabled);
            this.setIfModified((ModConfigSpec.ConfigValue)this.hudReferencePosVal, this.hudReferencePos);
            this.setIfModified((ModConfigSpec.ConfigValue)this.hudScaleVal, this.hudScale);
            this.setIfModified((ModConfigSpec.ConfigValue)this.hudBehindChatBoxVal, this.hudBehindChatBox);
            this.setIfModified((ModConfigSpec.ConfigValue)this.hudInfoVal, this.hudInfo);
            this.setIfModified((ModConfigSpec.ConfigValue)this.profileVal, this.profile);
            for (int i = 0; i < 8; ++i) {
                this.setIfModified((ModConfigSpec.ConfigValue)this.hudOffsetVal[i * 2], this.hudPos[i + 1].offsetX);
                this.setIfModified((ModConfigSpec.ConfigValue)this.hudOffsetVal[i * 2 + 1], this.hudPos[i + 1].offsetY);
                this.setIfModified((ModConfigSpec.ConfigValue)this.hudAlignmentVal[i], this.hudPos[i + 1].alignment);
            }
        }

        protected <T> void setIfModified(ModConfigSpec.ConfigValue<T> configValue, T value) {
            if (value != null && !value.equals(configValue.get())) {
                Logger.debug("Config changed: ", CommonConfig.getPath(configValue), " ", configValue.get(), "->", value);
                configValue.set(value);
                configValue.save();
            }
        }

        public void setHudReferencePos(int loc) {
            this.hudReferencePos = loc;
            this.curHudPos = this.hudPos[loc];
        }

        public int getHudReferencePos() {
            return this.hudReferencePos;
        }

        public void resetHudOffsetsAndAlignments() {
            for (int i = 0; i < 8; ++i) {
                this.hudPos[i + 1].setOffset(this.hudPosDefault[i + 1].offsetX, this.hudPosDefault[i + 1].offsetY);
                this.hudPos[i + 1].alignment = this.hudPosDefault[i + 1].alignment;
            }
            this.writeToConfigData();
        }
    }
}

