/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix;

import java.util.List;
import java.util.Set;
import net.mehvahdjukaar.modelfix.ModelFix;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ModelFixGeom {
    private static final ResourceLocation BLOCK_ATLAS = ResourceLocation.parse((String)"textures/atlas/blocks.png");

    public static float getShrinkRatio(ResourceLocation atlasLocation, float defaultValue, float returnValue) {
        if (atlasLocation.equals((Object)BLOCK_ATLAS) && defaultValue == returnValue) {
            return (float)((double)defaultValue * ModelFix.shrinkMult.get());
        }
        return -1.0f;
    }

    public static void createOrExpandSpan(List<ItemModelGenerator.Span> listSpans, ItemModelGenerator.SpanFacing spanFacing, int pixelX, int pixelY) {
        int length;
        ItemModelGenerator.Span existingSpan = null;
        for (ItemModelGenerator.Span span : listSpans) {
            int i;
            if (span.getFacing() != spanFacing) continue;
            int n = i = spanFacing.isHorizontal() ? pixelY : pixelX;
            if (span.getAnchor() != i || ModelFix.expansion.get() != 0.0 && span.getMax() != (!spanFacing.isHorizontal() ? pixelY : pixelX) - 1) continue;
            existingSpan = span;
            break;
        }
        int n = length = spanFacing.isHorizontal() ? pixelX : pixelY;
        if (existingSpan == null) {
            int newStart = spanFacing.isHorizontal() ? pixelY : pixelX;
            listSpans.add(new ItemModelGenerator.Span(spanFacing, length, newStart));
        } else {
            existingSpan.expand(length);
        }
    }

    public static void enlargeFaces(CallbackInfoReturnable<List<BlockElement>> cir) {
        double inc = ModelFix.indent.get();
        double inc2 = ModelFix.expansion.get();
        for (BlockElement e : (List)cir.getReturnValue()) {
            Vector3f from = e.from;
            Vector3f to = e.to;
            Set set = e.faces.keySet();
            if (set.size() != 1) continue;
            Direction dir = (Direction)set.stream().findAny().get();
            switch (dir) {
                case UP: {
                    from.set((double)from.x() - inc2, (double)from.y() - inc, (double)from.z() - inc2);
                    to.set((double)to.x() + inc2, (double)to.y() - inc, (double)to.z() + inc2);
                    break;
                }
                case DOWN: {
                    from.set((double)from.x() - inc2, (double)from.y() + inc, (double)from.z() - inc2);
                    to.set((double)to.x() + inc2, (double)to.y() + inc, (double)to.z() + inc2);
                    break;
                }
                case WEST: {
                    from.set((double)from.x() - inc, (double)from.y() + inc2, (double)from.z() - inc2);
                    to.set((double)to.x() - inc, (double)to.y() - inc2, (double)to.z() + inc2);
                    break;
                }
                case EAST: {
                    from.set((double)from.x() + inc, (double)from.y() + inc2, (double)from.z() - inc2);
                    to.set((double)to.x() + inc, (double)to.y() - inc2, (double)to.z() + inc2);
                }
            }
        }
    }
}

