/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.level.ItemLike;

public class EmiFireworkStarFadeRecipe
extends EmiPatternCraftingRecipe {
    private static final List<DyeItem> DYES = Stream.of(DyeColor.values()).map(DyeItem::byColor).toList();

    public EmiFireworkStarFadeRecipe(ResourceLocation id) {
        super(List.of(EmiIngredient.of(DYES.stream().map(i -> EmiStack.of((ItemLike)i)).collect(Collectors.toList())), EmiStack.of((ItemLike)Items.FIREWORK_STAR)), EmiStack.of((ItemLike)Items.FIREWORK_STAR), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        return new GeneratedSlotWidget(r -> {
            EmiStack fireworkStar = this.getFireworkStar((Random)r, false);
            List<DyeItem> dyeItems = this.getDyes((Random)r, 8);
            int s = slot - 1;
            if (slot == 0) {
                return fireworkStar;
            }
            if (s < dyeItems.size()) {
                return EmiStack.of((ItemLike)dyeItems.get(s));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> this.getFireworkStar((Random)r, true), this.unique, x, y);
    }

    private List<DyeItem> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private EmiStack getFireworkStar(Random random, Boolean faded) {
        IntList fadedColors;
        ItemStack stack = new ItemStack((ItemLike)Items.FIREWORK_STAR);
        int items = 0;
        int amount = random.nextInt(5);
        FireworkExplosion.Shape type = FireworkExplosion.Shape.values()[random.nextInt(FireworkExplosion.Shape.values().length)];
        if (amount != 0) {
            ++items;
        }
        amount = random.nextInt(4);
        boolean flicker = false;
        boolean trail = false;
        if (amount == 0) {
            flicker = true;
            ++items;
        } else if (amount == 1) {
            trail = true;
            ++items;
        } else if (amount == 2) {
            flicker = true;
            trail = true;
            items += 2;
        }
        List<DyeItem> dyeItems = this.getDyes(random, 8 - items);
        IntArrayList colors = new IntArrayList();
        for (DyeItem dyeItem : dyeItems) {
            colors.add(dyeItem.getDyeColor().getFireworkColor());
        }
        if (faded.booleanValue()) {
            List<DyeItem> dyeItemsFaded = this.getDyes(random, 8);
            fadedColors = new IntArrayList();
            for (DyeItem dyeItem : dyeItemsFaded) {
                fadedColors.add(dyeItem.getDyeColor().getFireworkColor());
            }
        } else {
            fadedColors = IntLists.emptyList();
        }
        FireworkExplosion component = new FireworkExplosion(type, (IntList)colors, fadedColors, trail, flicker);
        stack.set(DataComponents.FIREWORK_EXPLOSION, (Object)component);
        return EmiStack.of(stack);
    }
}

