/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.api.client;

import dev.anvilcraft.rg.api.RGEnvironment;
import dev.anvilcraft.rg.api.RGRule;
import dev.anvilcraft.rg.api.RGRuleManager;
import dev.anvilcraft.rg.api.client.RGClientRules;
import dev.anvilcraft.rg.api.event.RGRuleChangeEvent;
import java.lang.annotation.ElementType;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforgespi.language.ModFileScanData;

public class ClientRGRuleManager
extends RGRuleManager {
    public static final String ANNOTATION_NAME = "L" + RGClientRules.class.getName().replace(".", "/") + ";";
    private final Map<RGRule<?>, ModConfigSpec.ConfigValue<?>> configValueMap = new LinkedHashMap();
    private final Map<String, ModConfigSpec> specMap = new LinkedHashMap<String, ModConfigSpec>();

    public ClientRGRuleManager(String namespace) {
        super(namespace, RGEnvironment.CLIENT);
    }

    public void compileContent() throws ClassNotFoundException {
        ProgressMeter meter = StartupNotificationManager.addProgressBar((String)"Load Server Rules", (int)LoadingModList.get().getModFiles().size());
        for (ModFileInfo modFile : LoadingModList.get().getModFiles()) {
            meter.increment();
            ModFileScanData scanData = modFile.getFile().getScanResult();
            for (ModFileScanData.AnnotationData annotation : scanData.getAnnotations()) {
                if (!annotation.annotationType().getDescriptor().equals(ANNOTATION_NAME) || annotation.targetType() != ElementType.TYPE) continue;
                String memberName = annotation.memberName();
                Class<?> clazz = Class.forName(memberName);
                String modId = (String)annotation.annotationData().get("value");
                if (modId == null) {
                    modId = "rolling_gate";
                }
                this.register(clazz, modId);
            }
        }
        StartupNotificationManager.popBar((ProgressMeter)meter);
        this.initModConfigSpecs();
    }

    public <V extends Comparable<? super V>> void initModConfigSpecs() {
        LinkedHashMap<String, ModConfigSpec.Builder> builders = new LinkedHashMap<String, ModConfigSpec.Builder>();
        for (Map.Entry entry : this.rules.entrySet()) {
            ModConfigSpec.BooleanValue spec;
            String key = (String)entry.getKey();
            RGRule rule = (RGRule)entry.getValue();
            String namespace = rule.namespace();
            ModConfigSpec.Builder builder = builders.getOrDefault(namespace, new ModConfigSpec.Builder());
            Class type = rule.codec().clazz();
            if (rule.categories().length >= 1) {
                builder.push(rule.categories()[0]);
            }
            if (type == Boolean.class) {
                spec = builder.define(rule.name(), ((Boolean)rule.defaultValue()).booleanValue());
            } else if (rule.onlyAllowed()) {
                spec = builder.defineInList(key, rule.defaultValue(), rule.getTypedAllowed());
            } else if (Number.class.isAssignableFrom(type)) {
                Object min = RGRule.getRuleMin(rule.min(), rule.codec());
                Object max = RGRule.getRuleMax(rule.max(), rule.codec());
                spec = builder.defineInRange(rule.name(), (Comparable)rule.defaultValue(), (Comparable)min, (Comparable)max, type);
            } else {
                spec = builder.define(key, rule.defaultValue());
            }
            if (rule.categories().length >= 1) {
                builder.pop();
            }
            this.configValueMap.put(rule, (ModConfigSpec.ConfigValue<?>)spec);
            builders.put(namespace, builder);
        }
        for (Map.Entry entry : builders.entrySet()) {
            ModConfigSpec.Builder builder = (ModConfigSpec.Builder)entry.getValue();
            ModConfigSpec spec = builder.build();
            this.specMap.put((String)entry.getKey(), spec);
        }
    }

    @Override
    public void reInit() {
        for (Map.Entry<RGRule<?>, ModConfigSpec.ConfigValue<?>> entry : this.configValueMap.entrySet()) {
            RGRule<?> key = entry.getKey();
            ModConfigSpec.ConfigValue<?> value = entry.getValue();
            key.setFieldValue(value.get().toString());
        }
    }

    public <T> void onRuleChange(RGRule<?> rule, Object oldValue, Object newValue) {
        ModConfigSpec.ConfigValue<?> value = this.configValueMap.get(rule);
        if (value == null) {
            return;
        }
        Object value1 = newValue;
        if (!value.get().equals(value1)) {
            value.set(value1);
        }
    }

    public <T> void loadSuccess() {
        for (RGRule<?> rule : this.configValueMap.keySet()) {
            RGRuleChangeEvent.Client event = new RGRuleChangeEvent.Client(rule, rule.defaultValue(), rule.getValue());
            NeoForge.EVENT_BUS.post(event);
        }
    }

    @Generated
    public Map<RGRule<?>, ModConfigSpec.ConfigValue<?>> getConfigValueMap() {
        return this.configValueMap;
    }

    @Generated
    public Map<String, ModConfigSpec> getSpecMap() {
        return this.specMap;
    }
}

