/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.anvilcraft.rg.RollingGate;
import dev.anvilcraft.rg.api.ConfigUtil;
import dev.anvilcraft.rg.api.RGCodec;
import dev.anvilcraft.rg.api.RGEnvironment;
import dev.anvilcraft.rg.api.RGRule;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

public class RGRuleManager {
    public static final Gson GSON;
    protected final RGEnvironment environment;
    protected final Map<String, RGRule<?>> rules = new HashMap();
    protected final String managerNamespace;
    protected final Path globalConfigPath;
    protected final Map<RGRule<?>, Object> globalConfig = new HashMap();
    protected String namespace = "rolling_gate";
    protected final Set<String> categories = new HashSet<String>();

    public RGRuleManager(String namespace, @NotNull RGEnvironment environment) {
        this.managerNamespace = namespace;
        this.environment = environment;
        this.globalConfigPath = FMLPaths.CONFIGDIR.get().resolve("%s%s.json".formatted(namespace, this.environment.isClient() ? "_client" : ""));
    }

    @NotNull
    protected Map<RGRule<?>, Object> setSaveRules(@NotNull JsonObject config) {
        HashMap result = new HashMap();
        for (Map.Entry entry : config.entrySet()) {
            RGRule<?> rule = this.rules.get(entry.getKey());
            if (rule == null) {
                RollingGate.LOGGER.warn("{}({}) not exist.", entry.getKey(), entry.getValue());
                continue;
            }
            rule.setFieldValue((JsonElement)entry.getValue());
            result.put(rule, rule.getValue());
        }
        return result;
    }

    @NotNull
    protected Map<String, Object> getSerializedConfig(@NotNull Map<RGRule<?>, Object> configs) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<RGRule<?>, Object> entry : configs.entrySet()) {
            RGRule<?> key = entry.getKey();
            result.put(key.serialize(), entry.getValue());
        }
        return result;
    }

    public void reInit() {
        this.globalConfig.clear();
        this.globalConfig.putAll(this.setSaveRules(ConfigUtil.getOrCreateContent(this.globalConfigPath)));
    }

    public void addRule(@NotNull RGRule<?> rule) {
        this.rules.put(rule.serialize(), rule);
        this.categories.addAll(Arrays.asList(rule.categories()));
    }

    @NotNull
    private static List<RGRule<?>> of(String namespace, @NotNull Class<?> rules) {
        ArrayList ruleList = new ArrayList();
        for (Field field : rules.getDeclaredFields()) {
            RGRule.checkType(field);
            RGRule rule = RGRule.of(namespace, field);
            if (rule == null) continue;
            ruleList.add(rule);
        }
        return ruleList;
    }

    public void register(Class<?> rules) {
        this.register(rules, this.namespace);
    }

    public void register(Class<?> rules, String namespace) {
        RGRuleManager.of(namespace, rules).forEach(this::addRule);
    }

    @NotNull
    public String getDescriptionCategoryKey(String category) {
        return "rolling_gate.category.%s".formatted(category);
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        for (Map.Entry<String, RGCodec<?>> entry : RGRule.CODECS.entrySet()) {
            RGCodec<?> codec = entry.getValue();
            if (codec.isBuiltIn()) continue;
            builder.registerTypeAdapter(codec.clazz(), codec);
        }
        GSON = builder.setPrettyPrinting().create();
    }
}

