/*
 * Decompiled with CFR 0.152.
 */
package dev.anvilcraft.rg.api;

import com.google.gson.JsonElement;
import dev.anvilcraft.rg.RollingGate;
import dev.anvilcraft.rg.api.RGCodec;
import dev.anvilcraft.rg.api.RGEnvironment;
import dev.anvilcraft.rg.api.RGRuleException;
import dev.anvilcraft.rg.api.RGValidator;
import dev.anvilcraft.rg.api.Rule;
import dev.anvilcraft.rg.api.event.RGRuleChangeEvent;
import dev.anvilcraft.rg.api.event.RGValidatorNotPassedEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record RGRule<T>(String namespace, Class<T> type, RGEnvironment environment, String[] categories, String serialize, boolean onlyAllowed, String[] allowed, String min, String max, List<RGValidator<T>> validators, T defaultValue, Field field, RGCodec<T> codec) {
    public static final Map<String, RGCodec<?>> CODECS = new HashMap<String, RGCodec<?>>(){
        {
            this.put("java.lang.Boolean", RGCodec.BOOLEAN);
            this.put("boolean", RGCodec.BOOLEAN);
            this.put("java.lang.Byte", RGCodec.BYTE);
            this.put("byte", RGCodec.BYTE);
            this.put("java.lang.Short", RGCodec.SHORT);
            this.put("short", RGCodec.SHORT);
            this.put("java.lang.Integer", RGCodec.INTEGER);
            this.put("int", RGCodec.INTEGER);
            this.put("java.lang.Long", RGCodec.LONG);
            this.put("long", RGCodec.LONG);
            this.put("java.lang.Float", RGCodec.FLOAT);
            this.put("float", RGCodec.FLOAT);
            this.put("java.lang.Double", RGCodec.DOUBLE);
            this.put("double", RGCodec.DOUBLE);
            this.put("java.lang.String", RGCodec.STRING);
        }
    };

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> RGRule<T> of(String namespace, @NotNull Field field) {
        void var9_11;
        String name = field.getName();
        Rule rule = field.getAnnotation(Rule.class);
        if (rule == null) {
            return null;
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            throw RGRuleException.notStatic(name);
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            throw RGRuleException.notPublic(name);
        }
        if (Modifier.isFinal(field.getModifiers())) {
            throw RGRuleException.beFinal(name);
        }
        Class<?> type = RGRule.checkType(field);
        String serialize = rule.serialize().isEmpty() ? RGRule.caseToSnake(name) : rule.serialize();
        RGRule.checkSerialize(serialize);
        ArrayList<RGValidator<T>> validators = new ArrayList<RGValidator<T>>();
        Class<? extends RGValidator>[] classArray = rule.validator();
        int n = classArray.length;
        boolean bl = false;
        while (var9_11 < n) {
            Class<? extends RGValidator> validator = classArray[var9_11];
            try {
                validators.add(validator.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                RollingGate.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            ++var9_11;
        }
        RGCodec rgCodec = CODECS.getOrDefault(type.getTypeName(), null);
        String[] allowed = rule.allowed();
        if (rgCodec == null) {
            throw RGRuleException.unsupportedType(name, type);
        }
        if (rgCodec.clazz() == Boolean.class) {
            validators.add(new RGValidator.BooleanValidator());
            if (allowed.length < 1) {
                allowed = new String[]{"true", "false"};
            }
        } else if (rgCodec.clazz() == String.class && validators.isEmpty()) {
            validators.add(new RGValidator.StringValidator());
        } else if (Number.class.isAssignableFrom(rgCodec.clazz())) {
            if (rgCodec.clazz() == Integer.class) {
                final int n2 = (Integer)RGRule.getRuleMin(rule.min(), rgCodec);
                final int max = (Integer)RGRule.getRuleMax(rule.max(), rgCodec);
                validators.add(new RGValidator.IntegerValidator(){

                    @Override
                    public @NotNull Map.Entry<Integer, Integer> getRange() {
                        return Map.entry(n2, max);
                    }
                });
            } else if (rgCodec.clazz() == Double.class) {
                final double d = (Double)RGRule.getRuleMin(rule.min(), rgCodec);
                final double max = (Double)RGRule.getRuleMax(rule.max(), rgCodec);
                validators.add(new RGValidator.DoubleValidator(){

                    @Override
                    public @NotNull Map.Entry<Double, Double> getRange() {
                        return Map.entry(d, max);
                    }
                });
            } else if (rgCodec.clazz() == Float.class) {
                final float f = ((Float)RGRule.getRuleMin(rule.min(), rgCodec)).floatValue();
                final float max = ((Float)RGRule.getRuleMax(rule.max(), rgCodec)).floatValue();
                validators.add(new RGValidator.FloatValidator(){

                    @Override
                    public @NotNull Map.Entry<Float, Float> getRange() {
                        return Map.entry(Float.valueOf(f), Float.valueOf(max));
                    }
                });
            } else if (rgCodec.clazz() == Short.class) {
                final short s = (Short)RGRule.getRuleMin(rule.min(), rgCodec);
                final short max = (Short)RGRule.getRuleMax(rule.max(), rgCodec);
                validators.add(new RGValidator.ShortValidator(){

                    @Override
                    public @NotNull Map.Entry<Short, Short> getRange() {
                        return Map.entry(s, max);
                    }
                });
            } else if (rgCodec.clazz() == Byte.class) {
                final byte by = (Byte)RGRule.getRuleMin(rule.min(), rgCodec);
                final byte max = (Byte)RGRule.getRuleMax(rule.max(), rgCodec);
                validators.add(new RGValidator.ByteValidator(){

                    @Override
                    public @NotNull Map.Entry<Byte, Byte> getRange() {
                        return Map.entry(by, max);
                    }
                });
            } else if (rgCodec.clazz() == Long.class) {
                final long l = (Long)RGRule.getRuleMin(rule.min(), rgCodec);
                final long max = (Long)RGRule.getRuleMax(rule.max(), rgCodec);
                validators.add(new RGValidator.LongValidator(){

                    @Override
                    public @NotNull Map.Entry<Long, Long> getRange() {
                        return Map.entry(l, max);
                    }
                });
            }
        }
        try {
            return new RGRule<Object>(namespace, type, rule.env(), rule.categories(), serialize, rule.onlyAllowed(), allowed, rule.min(), rule.max(), validators, field.get(null), field, rgCodec);
        }
        catch (Exception exception) {
            throw RGRuleException.createRuleFailed(name);
        }
    }

    public static Object getRuleMin(String min, @NotNull RGCodec<?> rgCodec) {
        if (Number.class.isAssignableFrom(rgCodec.clazz())) {
            if (rgCodec.clazz() == Integer.class) {
                return "-inf".equals(min) ? Integer.MIN_VALUE : (Integer)rgCodec.decode(min);
            }
            if (rgCodec.clazz() == Double.class) {
                return "-inf".equals(min) ? Double.MIN_VALUE : (Double)rgCodec.decode(min);
            }
            if (rgCodec.clazz() == Float.class) {
                return Float.valueOf("-inf".equals(min) ? Float.MIN_VALUE : ((Float)rgCodec.decode(min)).floatValue());
            }
            if (rgCodec.clazz() == Short.class) {
                return "-inf".equals(min) ? (short)Short.MIN_VALUE : (Short)rgCodec.decode(min);
            }
            if (rgCodec.clazz() == Byte.class) {
                return "-inf".equals(min) ? (byte)-128 : (Byte)rgCodec.decode(min);
            }
            if (rgCodec.clazz() == Long.class) {
                return "-inf".equals(min) ? Long.MIN_VALUE : (Long)rgCodec.decode(min);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(rgCodec.clazz()));
    }

    public static Object getRuleMax(String max, @NotNull RGCodec<?> rgCodec) {
        if (Number.class.isAssignableFrom(rgCodec.clazz())) {
            if (rgCodec.clazz() == Integer.class) {
                return "inf".equals(max) ? Integer.MAX_VALUE : (Integer)rgCodec.decode(max);
            }
            if (rgCodec.clazz() == Double.class) {
                return "inf".equals(max) ? Double.MAX_VALUE : (Double)rgCodec.decode(max);
            }
            if (rgCodec.clazz() == Float.class) {
                return Float.valueOf("inf".equals(max) ? Float.MAX_VALUE : ((Float)rgCodec.decode(max)).floatValue());
            }
            if (rgCodec.clazz() == Short.class) {
                return "inf".equals(max) ? (short)Short.MAX_VALUE : (Short)rgCodec.decode(max);
            }
            if (rgCodec.clazz() == Byte.class) {
                return "inf".equals(max) ? (byte)127 : (Byte)rgCodec.decode(max);
            }
            if (rgCodec.clazz() == Long.class) {
                return "inf".equals(max) ? Long.MAX_VALUE : (Long)rgCodec.decode(max);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(rgCodec.clazz()));
    }

    @NotNull
    public String name() {
        return this.field.getName();
    }

    public T getValue() {
        try {
            return (T)this.field.get(null);
        }
        catch (IllegalAccessException e) {
            throw RGRuleException.illegalAccess(this.name());
        }
    }

    @NotNull
    public @Unmodifiable List<T> getTypedAllowed() {
        return Arrays.stream(this.allowed).map(this.codec::decode).toList();
    }

    public static Class<?> checkType(@NotNull Field field) {
        RGCodec rgCodec = CODECS.getOrDefault(field.getType().getTypeName(), null);
        if (rgCodec != null) {
            return rgCodec.clazz();
        }
        throw RGRuleException.unsupportedType(field.getName(), field.getType());
    }

    public static void checkSerialize(@NotNull String str) {
        if (str.isEmpty() || !str.matches("^[a-z][a-z0-9_]*$")) {
            throw new RuntimeException("Invalid serialize string %s".formatted(str));
        }
    }

    @NotNull
    public static String caseToSnake(@NotNull String str) {
        return str.replaceAll("([a-z])([A-Z]+)", "$1_$2").toLowerCase();
    }

    public void setFieldValue(String value) {
        try {
            for (RGValidator<Object> rGValidator : this.validators) {
                if (rGValidator.validate(this.field.get(null), value)) continue;
                NeoForge.EVENT_BUS.post(new RGValidatorNotPassedEvent<T>(this, this.getValue()));
                throw new RGRuleException("Illegal value: %s, reason: %s", value, rGValidator.reason());
            }
            RGRuleChangeEvent event = this.environment().isServer() ? new RGRuleChangeEvent.Server<T>(this, this.getValue(), this.codec.decode(value), ServerLifecycleHooks.getCurrentServer()) : new RGRuleChangeEvent.Client<T>(this, this.getValue(), this.codec.decode(value));
            NeoForge.EVENT_BUS.post(event);
            if (event.isCanceled()) {
                return;
            }
            this.field.set(null, event.getNewValue());
        }
        catch (IllegalAccessException e) {
            throw new RGRuleException("Illegal value: %s", value);
        }
    }

    public void setFieldValue(JsonElement primitive) {
        RGCodec rgCodec = CODECS.getOrDefault(this.field.getType().getTypeName(), null);
        if (rgCodec != null) {
            if (primitive.isJsonPrimitive() && primitive.getAsJsonPrimitive().isString()) {
                this.setFieldValue(primitive.getAsString());
            } else {
                this.setFieldValue(primitive.toString());
            }
            return;
        }
        throw new RGRuleException("Field %s has unsupported type %s", this.name(), this.field.getType().getTypeName());
    }

    @NotNull
    public String getNameTranslationKey() {
        return "%s.rolling_gate.rule.%s".formatted(this.namespace, this.serialize);
    }

    @NotNull
    public String getDescriptionTranslationKey() {
        return "%s.rolling_gate.rule.%s.desc".formatted(this.namespace, this.serialize);
    }
}

