/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EquipmentAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModAttributes;
import artifacts.registry.ModDataComponents;
import artifacts.registry.ModGameEvents;
import artifacts.registry.ModSoundEvents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public record DoubleJump(Value<Boolean> enabled, Value<Double> fallDamageMultiplier, Value<Double> sprintHorizontalVelocity, Value<Double> sprintVerticalVelocity) implements EquipmentAbility
{
    public static final Codec<DoubleJump> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ValueTypes.enabledField().forGetter(DoubleJump::enabled), (App)ValueTypes.FRACTION.codec().optionalFieldOf("fall_damage_multiplier", Value.of(0.0)).forGetter(DoubleJump::fallDamageMultiplier), (App)ValueTypes.NON_NEGATIVE_DOUBLE.codec().optionalFieldOf("sprint_jump_horizontal_velocity", Value.of(0.0)).forGetter(DoubleJump::sprintHorizontalVelocity), (App)ValueTypes.NON_NEGATIVE_DOUBLE.codec().optionalFieldOf("sprint_jump_vertical_velocity", Value.of(0.0)).forGetter(DoubleJump::sprintVerticalVelocity)).apply((Applicative)instance, DoubleJump::new));
    public static final StreamCodec<ByteBuf, DoubleJump> STREAM_CODEC = StreamCodec.composite(ValueTypes.BOOLEAN.streamCodec(), DoubleJump::enabled, ValueTypes.FRACTION.streamCodec(), DoubleJump::fallDamageMultiplier, ValueTypes.NON_NEGATIVE_DOUBLE.streamCodec(), DoubleJump::sprintHorizontalVelocity, ValueTypes.NON_NEGATIVE_DOUBLE.streamCodec(), DoubleJump::sprintVerticalVelocity, DoubleJump::new);

    public static void jump(Player player) {
        double fallDamageMultiplier = EquipmentHelper.minDouble(ModDataComponents.DOUBLE_JUMP.get(), (LivingEntity)player, 1.0, ability -> (Double)ability.fallDamageMultiplier().get(), true);
        if (player.fallDistance > 0.0f && fallDamageMultiplier > 0.0) {
            player.causeFallDamage(player.fallDistance, (float)fallDamageMultiplier, player.damageSources().fall());
        }
        player.fallDistance = 0.0f;
        double upwardsMotion = 0.5;
        if (player.hasEffect(MobEffects.JUMP)) {
            upwardsMotion += 0.1 * (double)(player.getEffect(MobEffects.JUMP).getAmplifier() + 1);
        }
        if (player.isSprinting()) {
            upwardsMotion *= 1.0 + EquipmentHelper.maxDouble(ModDataComponents.DOUBLE_JUMP.get(), (LivingEntity)player, ability -> (Double)ability.sprintVerticalVelocity().get(), true);
        }
        Vec3 motion = player.getDeltaMovement();
        double motionMultiplier = 0.0;
        if (player.isSprinting()) {
            motionMultiplier = EquipmentHelper.maxDouble(ModDataComponents.DOUBLE_JUMP.get(), (LivingEntity)player, ability -> (Double)ability.sprintHorizontalVelocity().get(), true);
        }
        float direction = (float)((double)player.getYRot() * Math.PI / 180.0);
        player.setDeltaMovement(player.getDeltaMovement().add((double)(-Mth.sin((float)direction)) * motionMultiplier, upwardsMotion - motion.y, (double)Mth.cos((float)direction) * motionMultiplier));
        player.hasImpulse = true;
        player.awardStat(Stats.JUMP);
        if (player.isSprinting()) {
            player.causeFoodExhaustion(0.2f);
        } else {
            player.causeFoodExhaustion(0.05f);
        }
        if (!player.level().isClientSide()) {
            double chance = player.getAttributeValue(ModAttributes.FLATULENCE);
            if ((double)player.getRandom().nextFloat() < chance) {
                player.gameEvent(ModGameEvents.FART);
                player.level().playSound(null, (Entity)player, (SoundEvent)ModSoundEvents.FART.value(), SoundSource.PLAYERS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            } else {
                player.level().playSound(null, (Entity)player, SoundEvents.WOOL_FALL, SoundSource.PLAYERS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            }
        }
    }

    @Override
    public boolean isNonCosmetic() {
        return (Boolean)this.enabled().get();
    }
}

