/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.JSObjectTypeInfo;
import dev.latvian.mods.rhino.type.JSOptionalParam;
import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public record SlotFilter(Ingredient item, int index) {
    public static final SlotFilter EMPTY = new SlotFilter(Ingredient.EMPTY, -1);
    public static final TypeInfo TYPE_INFO = TypeInfo.INT.or(IngredientJS.TYPE_INFO).or((TypeInfo)new JSObjectTypeInfo(List.of(new JSOptionalParam("item", IngredientJS.TYPE_INFO, true), new JSOptionalParam("index", TypeInfo.INT, true))));
    public static final Codec<SlotFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.optionalFieldOf("item", (Object)Ingredient.EMPTY).forGetter(SlotFilter::item), (App)Codec.INT.optionalFieldOf("index", (Object)-1).forGetter(SlotFilter::index)).apply((Applicative)instance, SlotFilter::of));
    public static final StreamCodec<RegistryFriendlyByteBuf, SlotFilter> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SlotFilter::item, (StreamCodec)ByteBufCodecs.VAR_INT, SlotFilter::index, SlotFilter::of);

    public static SlotFilter of(Ingredient ingredient, int index) {
        return ingredient.isEmpty() && index == -1 ? EMPTY : new SlotFilter(ingredient, index);
    }

    public static SlotFilter wrap(Context cx, Object o, TypeInfo target) {
        if (o instanceof Number) {
            Number num = (Number)o;
            return SlotFilter.of(Ingredient.EMPTY, num.intValue());
        }
        if (o instanceof String || o instanceof Ingredient || o instanceof NativeRegExp || o instanceof Pattern) {
            return SlotFilter.of(IngredientJS.wrap(RegistryAccessContainer.of(cx), o), -1);
        }
        return (SlotFilter)((RecordTypeInfo)target).wrap(cx, o, target);
    }

    public boolean checkFilter(int index, ItemStack stack) {
        return !(this.index != -1 && this.index != index || this.item != Ingredient.EMPTY && !this.item.test(stack));
    }
}

