/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.core;

import com.mojang.blaze3d.platform.InputConstants;
import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.client.ClientProperties;
import dev.latvian.mods.kubejs.core.MinecraftEnvironmentKJS;
import dev.latvian.mods.kubejs.core.NoMixinException;
import dev.latvian.mods.kubejs.item.ItemClickedKubeEvent;
import dev.latvian.mods.kubejs.net.FirstClickPayload;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@RemapPrefixForJS(value="kjs$")
public interface MinecraftClientKJS
extends MinecraftEnvironmentKJS {
    default public Minecraft kjs$self() {
        return (Minecraft)this;
    }

    @Override
    default public Component kjs$getName() {
        return Component.literal((String)this.kjs$self().name());
    }

    @Override
    default public void kjs$tell(Component message) {
        this.kjs$self().player.kjs$tell(message);
    }

    @Override
    default public void kjs$setStatusMessage(Component message) {
        this.kjs$self().player.kjs$setStatusMessage(message);
    }

    @Override
    default public void kjs$runCommand(String command) {
        this.kjs$self().player.kjs$runCommand(command);
    }

    @Override
    default public void kjs$runCommandSilent(String command) {
        this.kjs$self().player.kjs$runCommandSilent(command);
    }

    @Override
    default public void kjs$setActivePostShader(@Nullable ResourceLocation id) {
        this.kjs$self().player.kjs$setActivePostShader(id);
    }

    @Nullable
    default public Screen kjs$getCurrentScreen() {
        return this.kjs$self().screen;
    }

    default public void kjs$setCurrentScreen(Screen gui) {
        this.kjs$self().setScreen(gui);
    }

    default public void kjs$setTitle(String t) {
        ClientProperties.get().windowTitle = t.trim();
        this.kjs$self().updateTitle();
    }

    default public String kjs$getTitle() {
        throw new NoMixinException();
    }

    default public String kjs$getCurrentWorldName() {
        ServerData server = this.kjs$self().getCurrentServer();
        return server == null ? "Singleplayer" : server.name;
    }

    default public boolean kjs$isKeyDown(int key) {
        return InputConstants.isKeyDown((long)this.kjs$self().getWindow().getWindow(), (int)key);
    }

    default public boolean kjs$isKeyMappingDown(KeyMapping key) {
        if (!key.isUnbound() && key.isConflictContextAndModifierActive()) {
            if (key.getKey().getType() == InputConstants.Type.KEYSYM) {
                return this.kjs$isKeyDown(key.getKey().getValue());
            }
            if (key.getKey().getType() == InputConstants.Type.MOUSE) {
                return GLFW.glfwGetMouseButton((long)this.kjs$self().getWindow().getWindow(), (int)key.getKey().getValue()) == 1;
            }
        }
        return false;
    }

    default public boolean kjs$isShiftDown() {
        return Screen.hasShiftDown();
    }

    default public boolean kjs$isCtrlDown() {
        return Screen.hasControlDown();
    }

    default public boolean kjs$isAltDown() {
        return Screen.hasAltDown();
    }

    @HideFromJS
    default public void kjs$startAttack0() {
        LocalPlayer player;
        ItemStack stack;
        ResourceKey key;
        if (ItemEvents.FIRST_LEFT_CLICKED.hasListeners() && ItemEvents.FIRST_LEFT_CLICKED.hasListeners((ResourceKey<Item>)(key = (stack = (player = this.kjs$self().player).getItemInHand(InteractionHand.MAIN_HAND)).getItem().kjs$getKey()))) {
            ItemEvents.FIRST_LEFT_CLICKED.post(ScriptType.CLIENT, (ResourceKey<Item>)key, new ItemClickedKubeEvent((Player)player, InteractionHand.MAIN_HAND, stack));
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new FirstClickPayload(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @HideFromJS
    default public void kjs$startUseItem0() {
        if (ItemEvents.FIRST_RIGHT_CLICKED.hasListeners()) {
            LocalPlayer player = this.kjs$self().player;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = player.getItemInHand(hand);
                ResourceKey key = stack.getItem().kjs$getKey();
                if (!ItemEvents.FIRST_RIGHT_CLICKED.hasListeners((ResourceKey<Item>)key)) continue;
                ItemEvents.FIRST_RIGHT_CLICKED.post(ScriptType.CLIENT, (ResourceKey<Item>)key, new ItemClickedKubeEvent((Player)player, hand, stack));
            }
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new FirstClickPayload(1), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @HideFromJS
    default public void kjs$afterResourcesLoaded(boolean reload) {
        if (reload) {
            ConsoleJS.CLIENT.stopCapturingErrors();
        }
        ConsoleJS.CLIENT.info("Client resource reload complete!");
    }
}

