/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.KubeJSCodecs;
import dev.latvian.mods.kubejs.bindings.ColorWrapper;
import dev.latvian.mods.kubejs.bindings.TextIcons;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.JSObjectType;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Context;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

@Info(value="The hub for all things text components. Format text to your hearts content!")
public interface TextWrapper {
    @Info(value="Returns a Component of the input")
    public static MutableComponent of(Context cx, @Nullable Object o) {
        Map map;
        if ((o = UtilsJS.wrap(o, JSObjectType.ANY)) == null) {
            return Component.literal((String)"null");
        }
        if (o instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)o;
            return component;
        }
        if (o instanceof Component) {
            Component component = (Component)o;
            return component.copy();
        }
        if (o instanceof CharSequence || o instanceof Number || o instanceof Character) {
            return TextWrapper.ofString(o.toString());
        }
        if (o instanceof Enum) {
            Enum e = (Enum)o;
            return TextWrapper.ofString(e.name());
        }
        if (o instanceof StringTag) {
            StringTag tag = (StringTag)o;
            String s = tag.getAsString();
            if (s.startsWith("{") && s.endsWith("}")) {
                try {
                    return (MutableComponent)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)JsonUtils.GSON.fromJson(s, JsonObject.class))).getOrThrow()).getFirst();
                }
                catch (JsonParseException ex) {
                    return Component.literal((String)("Error: " + String.valueOf((Object)ex)));
                }
            }
            return TextWrapper.ofString(s);
        }
        if (o instanceof Tag) {
            Tag tag = (Tag)o;
            return (MutableComponent)NbtUtils.toPrettyComponent((Tag)tag);
        }
        if (o instanceof Map && ((map = (Map)o).containsKey("text") || map.containsKey("translate"))) {
            Object a;
            MutableComponent text;
            if (map.containsKey("text")) {
                text = TextWrapper.ofString(map.get("text").toString());
            } else {
                Object[] with;
                Object v = map.get("with");
                if (v instanceof Collection) {
                    a = (Collection)v;
                    with = new Object[a.size()];
                    int i = 0;
                    Iterator iterator = a.iterator();
                    while (iterator.hasNext()) {
                        Object e1 = iterator.next();
                        with[i] = e1;
                        if (with[i] instanceof MapJS || with[i] instanceof ListJS) {
                            with[i] = TextWrapper.of(cx, e1);
                        }
                        ++i;
                    }
                } else {
                    with = new Object[]{};
                }
                text = Component.translatable((String)map.get("translate").toString(), (Object[])with);
            }
            if (map.containsKey("color")) {
                text.kjs$color(ColorWrapper.of(map.get("color")));
            }
            text.kjs$bold((Boolean)map.getOrDefault("bold", null));
            text.kjs$italic((Boolean)map.getOrDefault("italic", null));
            text.kjs$underlined((Boolean)map.getOrDefault("underlined", null));
            text.kjs$strikethrough((Boolean)map.getOrDefault("strikethrough", null));
            text.kjs$obfuscated((Boolean)map.getOrDefault("obfuscated", null));
            text.kjs$insertion((String)map.getOrDefault("insertion", null));
            text.kjs$font(map.containsKey("font") ? ResourceLocation.parse((String)map.get("font").toString()) : null);
            text.kjs$click(map.containsKey("click") ? TextWrapper.clickEventOf(cx, map.get("click")) : null);
            text.kjs$hover(map.containsKey("hover") ? TextWrapper.of(cx, map.get("hover")) : null);
            a = map.get("extra");
            if (a instanceof Iterable) {
                Iterable itr = (Iterable)a;
                for (Object e : itr) {
                    text.append((Component)TextWrapper.of(cx, e));
                }
            }
            return text;
        }
        if (o instanceof Iterable) {
            Iterable list = (Iterable)o;
            MutableComponent text = Component.empty();
            for (Object e1 : list) {
                text.append((Component)TextWrapper.of(cx, e1));
            }
            return text;
        }
        return TextWrapper.ofString(o.toString());
    }

    public static Component ofTag(Tag tag) {
        try {
            return (Component)((Pair)ComponentSerialization.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow()).getFirst();
        }
        catch (JsonParseException ex) {
            return Component.literal((String)("Error: " + String.valueOf((Object)ex)));
        }
    }

    @Info(value="Returns a plain component of the string, or empty if it is an empty string")
    public static MutableComponent ofString(String s) {
        return s.isEmpty() ? Component.empty() : Component.literal((String)s);
    }

    @Info(value="Checks if the passed in component, and all its children are empty")
    public static boolean isEmpty(Component component) {
        return component.getContents() == PlainTextContents.EMPTY && component.getSiblings().isEmpty();
    }

    @Info(value="Returns a ClickEvent of the input")
    public static ClickEvent clickEventOf(Context cx, Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClickEvent) {
            ClickEvent ce = (ClickEvent)o;
            return ce;
        }
        JsonObject json = MapJS.json(cx, o);
        if (json != null) {
            String action = GsonHelper.getAsString((JsonObject)json, (String)"action");
            String value = GsonHelper.getAsString((JsonObject)json, (String)"value");
            return (ClickEvent)KubeJSCodecs.fromJsonOrThrow((JsonElement)json, ClickEvent.CODEC);
        }
        String s = o.toString();
        String[] split = s.split(":", 2);
        return switch (split[0]) {
            case "command" -> new ClickEvent(ClickEvent.Action.RUN_COMMAND, split[1]);
            case "suggest_command" -> new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, split[1]);
            case "copy" -> new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, split[1]);
            case "file" -> new ClickEvent(ClickEvent.Action.OPEN_FILE, split[1]);
            default -> {
                for (ClickEvent.Action a : ClickEvent.Action.values()) {
                    if (!a.getSerializedName().equals(split[0])) continue;
                    yield new ClickEvent(a, split[1]);
                }
                yield new ClickEvent(ClickEvent.Action.OPEN_URL, s);
            }
        };
    }

    @Info(value="Returns a colorful representation of the input nbt. Useful for displaying NBT to the player")
    public static Component prettyPrintNbt(Tag tag) {
        return NbtUtils.toPrettyComponent((Tag)tag);
    }

    @Info(value="Joins all components in the list with the separator component")
    public static MutableComponent join(MutableComponent separator, Iterable<? extends Component> texts) {
        MutableComponent joined = Component.empty();
        boolean first = true;
        for (Component component : texts) {
            if (first) {
                first = false;
            } else if (!TextWrapper.isEmpty((Component)separator)) {
                joined.append((Component)separator);
            }
            joined.append(component);
        }
        return joined;
    }

    @Info(value="Returns an empty component")
    public static MutableComponent empty() {
        return Component.empty();
    }

    @Info(value="Joins all components")
    public static MutableComponent join(Component ... texts) {
        return TextWrapper.join(Component.empty(), Arrays.asList(texts));
    }

    @Info(value="Returns a plain component of the passed in string, even if empty")
    public static MutableComponent string(String text) {
        return Component.literal((String)text);
    }

    @Info(value="Returns a plain component of the input")
    public static MutableComponent literal(String text) {
        return Component.literal((String)text);
    }

    @Info(value="Returns a translatable component of the input key")
    public static MutableComponent translate(String key) {
        return Component.translatable((String)key);
    }

    @Info(value="Returns a translatable component of the input key, with args of the objects")
    public static MutableComponent translate(String key, Object ... objects) {
        return Component.translatable((String)key, (Object[])objects);
    }

    @Info(value="Returns a translatable component of the input key")
    public static MutableComponent translatable(String key) {
        return Component.translatable((String)key);
    }

    @Info(value="Returns a translatable component of the input key, with args of the objects")
    public static MutableComponent translatable(String key, Object ... objects) {
        return Component.translatable((String)key, (Object[])objects);
    }

    @Info(value="Returns a keybinding component of the input keybinding descriptor")
    public static MutableComponent keybind(String keybind) {
        return Component.keybind((String)keybind);
    }

    @Info(value="Returns a score component of the input objective, for the provided selector")
    public static MutableComponent score(String selector, String objective) {
        return MutableComponent.create((ComponentContents)new ScoreContents(selector, objective));
    }

    @Info(value="Returns a component displaying all entities matching the input selector")
    public static MutableComponent selector(String selector) {
        return MutableComponent.create((ComponentContents)new SelectorContents(selector, Optional.empty()));
    }

    @Info(value="Returns a component displaying all entities matching the input selector, with a custom separator")
    public static MutableComponent selector(String selector, Component separator) {
        return MutableComponent.create((ComponentContents)new SelectorContents(selector, Optional.of(separator)));
    }

    @Info(value="Returns a component of the input, colored black")
    public static MutableComponent black(MutableComponent text) {
        return text.kjs$black();
    }

    @Info(value="Returns a component of the input, colored dark blue")
    public static MutableComponent darkBlue(MutableComponent text) {
        return text.kjs$darkBlue();
    }

    @Info(value="Returns a component of the input, colored dark green")
    public static MutableComponent darkGreen(MutableComponent text) {
        return text.kjs$darkGreen();
    }

    @Info(value="Returns a component of the input, colored dark aqua")
    public static MutableComponent darkAqua(MutableComponent text) {
        return text.kjs$darkAqua();
    }

    @Info(value="Returns a component of the input, colored dark red")
    public static MutableComponent darkRed(MutableComponent text) {
        return text.kjs$darkRed();
    }

    @Info(value="Returns a component of the input, colored dark purple")
    public static MutableComponent darkPurple(MutableComponent text) {
        return text.kjs$darkPurple();
    }

    @Info(value="Returns a component of the input, colored gold")
    public static MutableComponent gold(MutableComponent text) {
        return text.kjs$gold();
    }

    @Info(value="Returns a component of the input, colored gray")
    public static MutableComponent gray(MutableComponent text) {
        return text.kjs$gray();
    }

    @Info(value="Returns a component of the input, colored dark gray")
    public static MutableComponent darkGray(MutableComponent text) {
        return text.kjs$darkGray();
    }

    @Info(value="Returns a component of the input, colored blue")
    public static MutableComponent blue(MutableComponent text) {
        return text.kjs$blue();
    }

    @Info(value="Returns a component of the input, colored green")
    public static MutableComponent green(MutableComponent text) {
        return text.kjs$green();
    }

    @Info(value="Returns a component of the input, colored aqua")
    public static MutableComponent aqua(MutableComponent text) {
        return text.kjs$aqua();
    }

    @Info(value="Returns a component of the input, colored red")
    public static MutableComponent red(MutableComponent text) {
        return text.kjs$red();
    }

    @Info(value="Returns a component of the input, colored light purple")
    public static MutableComponent lightPurple(MutableComponent text) {
        return text.kjs$lightPurple();
    }

    @Info(value="Returns a component of the input, colored yellow")
    public static MutableComponent yellow(MutableComponent text) {
        return text.kjs$yellow();
    }

    @Info(value="Returns a component of the input, colored white")
    public static MutableComponent white(MutableComponent text) {
        return text.kjs$white();
    }

    public static MutableComponent info(Component text) {
        return Component.empty().append((Component)TextIcons.info()).append((Component)TextIcons.smallSpace()).append(text);
    }

    public static MutableComponent warn(Component text) {
        return Component.empty().append((Component)TextIcons.info()).append((Component)TextIcons.smallSpace()).append(text);
    }
}

