/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.conczin.immersive_paintings.network.LazyNetworkManager;
import net.conczin.immersive_paintings.registration.Command;
import net.conczin.immersive_paintings.resources.PaintingsLoader;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="immersive_paintings", bus=EventBusSubscriber.Bus.GAME)
public class EventBus {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        Command.registerCommands(arg_0 -> ((CommandDispatcher)event.getDispatcher()).register(arg_0));
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        LazyNetworkManager.tickServer();
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        LazyNetworkManager.tickClient();
    }

    @SubscribeEvent
    public static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!event.getEntity().level().isClientSide) {
            ServerPaintingManager.playerLoggedOut((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getEntity().level().isClientSide) {
            ServerPaintingManager.playerLoggedIn((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new PaintingsLoader());
    }
}

