/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.entity;

import java.util.Optional;
import java.util.function.Predicate;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.ServerPaintingManager;
import net.conczin.immersive_paintings.compat.XercaPaintCompat;
import net.conczin.immersive_paintings.config.CommonConfig;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.s2c.OpenGuiPayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.conczin.immersive_paintings.registration.Entities;
import net.conczin.immersive_paintings.registration.Items;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ImmersivePaintingEntity
extends HangingEntity {
    protected static final Predicate<Entity> PREDICATE = entity -> entity instanceof ImmersivePaintingEntity;
    private static final EntityDataAccessor<ResourceLocation> MOTIVE = SynchedEntityData.defineId(ImmersivePaintingEntity.class, Entities.TRACKED_IDENTIFIER);
    private static final EntityDataAccessor<ResourceLocation> FRAME = SynchedEntityData.defineId(ImmersivePaintingEntity.class, Entities.TRACKED_IDENTIFIER);
    private static final EntityDataAccessor<ResourceLocation> MATERIAL = SynchedEntityData.defineId(ImmersivePaintingEntity.class, Entities.TRACKED_IDENTIFIER);
    private static final EntityDataAccessor<Integer> WIDTH = SynchedEntityData.defineId(ImmersivePaintingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> HEIGHT = SynchedEntityData.defineId(ImmersivePaintingEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int rotation;

    public ImmersivePaintingEntity(EntityType<? extends HangingEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void setDirection(Direction direction) {
        this.setDirection(direction, this.rotation);
    }

    public void setDirection(Direction direction, int rotation) {
        if (direction == null) {
            return;
        }
        this.direction = direction;
        this.rotation = rotation;
        if (direction.getAxis().isHorizontal()) {
            this.absRotateTo(direction.get2DDataValue() * 90, 0.0f);
        } else {
            this.absRotateTo(rotation, direction == Direction.UP ? 90.0f : -90.0f);
        }
        this.recalculateBoundingBox();
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    protected AABB calculateBoundingBox(BlockPos pos, Direction side) {
        Direction counter;
        Direction facing;
        Vec3 front = Vec3.atLowerCornerOf((Vec3i)side.getNormal());
        Vec3 up = side.getAxis().isVertical() ? new Vec3(0.0, 0.0, 1.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 cross = up.cross(front);
        if (this.rotation != 0) {
            float radians = (float)((double)this.rotation * Math.PI / 180.0);
            up = up.yRot(radians);
            cross = cross.yRot(radians);
        }
        double dx = this.offsetForPaintingSize(this.getPaintingWidth());
        double dy = this.offsetForPaintingSize(this.getPaintingHeight());
        if (side.getAxis().isVertical()) {
            facing = Direction.fromYRot((double)this.rotation);
            if (side.equals((Object)Direction.UP)) {
                facing = facing.getOpposite();
                counter = facing.getClockWise();
            } else {
                counter = facing.getCounterClockWise();
            }
        } else {
            facing = Direction.UP;
            counter = side.getCounterClockWise();
        }
        Vec3 vec3d = Vec3.atCenterOf((Vec3i)pos).relative(side, -0.46875).relative(counter, dx).relative(facing, dy);
        Vec3 shift = up.scale((double)this.getPaintingHeight()).add(cross.scale((double)this.getPaintingWidth())).add(front.scale(0.0625));
        return AABB.ofSize((Vec3)vec3d, (double)shift.x(), (double)shift.y(), (double)shift.z());
    }

    private double offsetForPaintingSize(int size) {
        return size % 2 == 0 ? 0.5 : 0.0;
    }

    public boolean survives() {
        if (Configs.COMMON.testIfSpaceEmpty && !this.level().noCollision((Entity)this)) {
            return false;
        }
        BlockPos blockPos = this.pos.relative(this.direction.getOpposite());
        BlockState blockState = this.level().getBlockState(blockPos);
        if (!blockState.isSolid() && !DiodeBlock.isDiode((BlockState)blockState)) {
            return false;
        }
        return this.level().getEntities((Entity)this, this.getBoundingBox(), PREDICATE).stream().noneMatch(v -> ((ImmersivePaintingEntity)v).direction == this.direction);
    }

    public boolean canBeCollidedWith() {
        return Configs.COMMON.paintingsHaveCollision;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.gameMode.getGameModeForPlayer() != GameType.ADVENTURE) {
                if (!XercaPaintCompat.interactWithPainting(this, player, hand)) {
                    CommonConfig config = Configs.COMMON;
                    NetworkHandler.sendToClient(serverPlayer, new OpenGuiPayload(OpenGuiPayload.GuiType.EDITOR, this.getId(), config.minPaintingResolution, config.maxPaintingResolution, config.showOtherPlayersPaintings, config.uploadPermissionLevel));
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)this.getItem());
    }

    public void dropItem(@Nullable Entity entity) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Player playerEntity;
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (entity instanceof Player && (playerEntity = (Player)entity).hasInfiniteMaterials()) {
                return;
            }
            this.spawnAtLocation((ItemLike)this.getItem());
        }
    }

    public void moveTo(double x, double y, double z, float yRot, float xRot) {
        this.setPos(x, y, z);
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.setPos(x, y, z);
    }

    public Vec3 trackingPosition() {
        return Vec3.atLowerCornerOf((Vec3i)this.pos);
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.PAINTING_PLACE, 1.0f, 1.0f);
    }

    public void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MOTIVE, (Object)Main.locate("none"));
        builder.define(FRAME, (Object)Main.locate("none"));
        builder.define(MATERIAL, (Object)Main.locate("none"));
        builder.define(WIDTH, (Object)1);
        builder.define(HEIGHT, (Object)1);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (MOTIVE.equals(data)) {
            Optional<Painting> painting = this.level().isClientSide ? ClientPaintingManager.getPainting(this.getMotive()) : ServerPaintingManager.getPainting(this.getServer(), this.getMotive());
            painting.ifPresent(p -> {
                this.getEntityData().set(WIDTH, (Object)Math.max(p.width(), 1));
                this.getEntityData().set(HEIGHT, (Object)Math.max(p.height(), 1));
                this.recalculateBoundingBox();
            });
        }
        super.onSyncedDataUpdated(data);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entityTrackerEntry) {
        return new ClientboundAddEntityPacket((Entity)this, this.rotation << 4 | (byte)this.direction.get3DDataValue(), this.getPos());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        int data = packet.getData();
        this.setDirection(Direction.from3DDataValue((int)(data & 0xF)), data >> 4);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        SynchedEntityData tracker = this.getEntityData();
        nbt.putString("Motive", ((ResourceLocation)tracker.get(MOTIVE)).toString());
        nbt.putString("Frame", ((ResourceLocation)tracker.get(FRAME)).toString());
        nbt.putString("Material", ((ResourceLocation)tracker.get(MATERIAL)).toString());
        nbt.putInt("Facing", this.direction.get3DDataValue());
        nbt.putInt("Rotation", this.rotation);
        super.addAdditionalSaveData(nbt);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        this.setFrame(ResourceLocation.parse((String)nbt.getString("Frame")));
        this.setMaterial(ResourceLocation.parse((String)nbt.getString("Material")));
        this.direction = Direction.from3DDataValue((int)nbt.getInt("Facing"));
        this.rotation = nbt.getInt("Rotation");
        super.readAdditionalSaveData(nbt);
        this.setMotive(ResourceLocation.parse((String)nbt.getString("Motive")));
    }

    public Item getItem() {
        return Items.PAINTING;
    }

    public boolean isGraffiti() {
        return false;
    }

    public boolean isGlowing() {
        return false;
    }

    public int getPaintingWidth() {
        return (Integer)this.getEntityData().get(WIDTH);
    }

    public int getPaintingHeight() {
        return (Integer)this.getEntityData().get(HEIGHT);
    }

    public ResourceLocation getMotive() {
        return (ResourceLocation)this.getEntityData().get(MOTIVE);
    }

    public void setMotive(ResourceLocation motive) {
        this.getEntityData().set(MOTIVE, (Object)motive);
    }

    public ResourceLocation getFrame() {
        return (ResourceLocation)this.getEntityData().get(FRAME);
    }

    public void setFrame(ResourceLocation frame) {
        this.getEntityData().set(FRAME, (Object)frame);
    }

    public ResourceLocation getMaterial() {
        return (ResourceLocation)this.getEntityData().get(MATERIAL);
    }

    public void setMaterial(ResourceLocation material) {
        this.getEntityData().set(MATERIAL, (Object)material);
    }
}

