/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class TexturedButtonWidget
extends Button {
    private final int tw;
    private final int th;
    private final int w;
    private final int h;
    private final ResourceLocation texture;

    public TexturedButtonWidget(int x, int y, int width, int height, ResourceLocation texture, int tw, int th, Component message, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, Button.DEFAULT_NARRATION);
        this.texture = texture;
        this.w = width;
        this.h = height;
        this.tw = tw;
        this.th = th;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.isHovered()) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.75f, (float)0.75f, (float)this.alpha);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        }
        graphics.blit(this.texture, this.getX(), this.getY(), 0.0f, (float)(this.active ? 0 : 16), this.w, this.h, this.tw, this.th);
        int j = this.active ? 0xFFFFFF : 0xA0A0A0;
        graphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }
}

