/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blocks;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import fr.iglee42.createcasing.config.ModConfigs;
import fr.iglee42.createcasing.registries.EncasedBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;

public class ConfigurableGearboxBlock
extends KineticBlock
implements IBE<GearboxBlockEntity> {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;

    public ConfigurableGearboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Direction face = context.getClickedFace();
        if (!((Boolean)state.getValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face))).booleanValue()) {
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue()) {
                return super.onSneakWrenched(state, context);
            }
            state = (BlockState)state.setValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face), (Comparable)Boolean.valueOf(true));
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
                state = (BlockState)state.setValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face.getOpposite()), (Comparable)Boolean.valueOf(true));
            }
        } else {
            state = (BlockState)state.setValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face), (Comparable)Boolean.valueOf(false));
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
                state = (BlockState)state.setValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face.getOpposite()), (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue() && context.getPlayer() != null && !context.getPlayer().isCreative()) {
                context.getPlayer().addItem(AllBlocks.SHAFT.asStack());
            }
        }
        return super.onWrenched(state, context);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.sidedSuccess((boolean)true);
        }
        Direction face = context.getClickedFace().getOpposite();
        if (!((Boolean)state.getValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face))).booleanValue()) {
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue()) {
                return super.onSneakWrenched(state, context);
            }
            state = (BlockState)state.setValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face), (Comparable)Boolean.valueOf(true));
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
                state = (BlockState)state.setValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face.getOpposite()), (Comparable)Boolean.valueOf(true));
            }
        } else {
            state = (BlockState)state.setValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face), (Comparable)Boolean.valueOf(false));
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
                state = (BlockState)state.setValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face.getOpposite()), (Comparable)Boolean.valueOf(false));
            }
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue() && context.getPlayer() != null && !context.getPlayer().isCreative()) {
                context.getPlayer().addItem(AllBlocks.SHAFT.asStack());
            }
        }
        KineticBlockEntity.switchToBlockState((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (BlockState)state);
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.isClientSide) {
            return ItemInteractionResult.sidedSuccess((boolean)true);
        }
        Direction face = result.getDirection();
        if (!stack.is(AllBlocks.SHAFT.asItem())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.isCrouching()) {
            face = face.getOpposite();
        }
        if (!((Boolean)state.getValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face))).booleanValue()) {
            if (!((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            state = (BlockState)state.setValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face), (Comparable)Boolean.valueOf(true));
            if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
                state = (BlockState)state.setValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face.getOpposite()), (Comparable)Boolean.valueOf(true));
            }
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)state);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return (Boolean)state.getValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(face));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
        super.createBlockStateDefinition(builder);
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.getValues().equals(newState.getValues());
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List stacks = super.getDrops(state, builder);
        if (!((Boolean)ModConfigs.common().kinetics.configurableGearboxRequiresShaft.get()).booleanValue()) {
            return stacks;
        }
        int shaftCount = 0;
        if (((Boolean)ModConfigs.common().kinetics.configurableGearboxChangeTwoFaces.get()).booleanValue()) {
            if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                ++shaftCount;
            }
        } else {
            if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
                ++shaftCount;
            }
            if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
                ++shaftCount;
            }
        }
        if (shaftCount > 0) {
            stacks.add(AllBlocks.SHAFT.asStack(shaftCount));
        }
        return stacks;
    }

    public static BooleanProperty getPropertyByDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    public Class<GearboxBlockEntity> getBlockEntityClass() {
        return GearboxBlockEntity.class;
    }

    public BlockEntityType<? extends GearboxBlockEntity> getBlockEntityType() {
        return (BlockEntityType)EncasedBlockEntities.CONFIGURABLE_GEARBOX.get();
    }
}

